/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.kaiser;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Kaiser7037
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int register;

    public Kaiser7037(CartFile cartFile) {
        super(cartFile, 16, 0, 32768, 28672);
    }

    @Override
    public void init() {
        this.setPrgBank(7, 15);
        this.setPrgBank(10, -4);
        this.setPrgBank(14, -2);
        this.setPrgBank(15, -1);
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xF000) == 45056) {
            return this.memory[0x7000 | address & 0xFFF];
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xF000) == 45056) {
            this.memory[0x7000 | address & 0xFFF] = value;
        } else {
            super.writeMemory(address, value);
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        block0 : switch (address & 0xE001) {
            case 32768: {
                this.register = value & 7;
                break;
            }
            case 32769: {
                switch (this.register) {
                    case 2: {
                        this.setNametable(0, value & 1);
                        break block0;
                    }
                    case 3: {
                        this.setNametable(2, value & 1);
                        break block0;
                    }
                    case 4: {
                        this.setNametable(1, value & 1);
                        break block0;
                    }
                    case 5: {
                        this.setNametable(3, value & 1);
                        break block0;
                    }
                    case 6: {
                        this.setPrgBank(8, value <<= 1);
                        this.setPrgBank(9, value | 1);
                        break block0;
                    }
                    case 7: {
                        this.setPrgBank(12, value <<= 1);
                        this.setPrgBank(13, value | 1);
                    }
                }
            }
        }
    }
}

