/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class VRC1
extends Mapper {
    private static final long serialVersionUID = 0L;

    public VRC1(CartFile cartFile) {
        super(cartFile, 8, 2);
        this.setPrgBank(7, -1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF000) {
            case 32768: {
                this.writePrgBank(4, value);
                break;
            }
            case 36864: {
                this.writeMirroring(value);
                break;
            }
            case 40960: {
                this.writePrgBank(5, value);
                break;
            }
            case 49152: {
                this.writePrgBank(6, value);
                break;
            }
            case 57344: {
                this.writeChrBank(0, value);
                break;
            }
            case 61440: {
                this.writeChrBank(1, value);
            }
        }
    }

    private void writeMirroring(int value) {
        if (this.nametableMirroring != 4) {
            this.setNametableMirroring(BitUtil.getBit(value, 0));
        }
        this.chrBanks[0] = this.chrBanks[0] & 0xF000 | (value & 2) << 15;
        this.chrBanks[1] = this.chrBanks[1] & 0xF000 | (value & 4) << 14;
    }

    private void writePrgBank(int bank, int value) {
        this.setPrgBank(bank, value & 0xF);
    }

    private void writeChrBank(int bank, int value) {
        this.chrBanks[bank] = this.chrBanks[bank] & 0x10000 | (value & 0xF) << 12;
    }
}

