/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class VRC3
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int irqCounter;
    private int irqLatch;
    private boolean irqEnableOnAck;
    private boolean irqEnabled;
    private boolean irq8bit;

    public VRC3(CartFile cartFile) {
        super(cartFile, 4, 0);
        this.setPrgBank(3, -1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF000) {
            case 32768: {
                this.irqLatch = this.irqLatch & 0xFFF0 | value & 0xF;
                break;
            }
            case 36864: {
                this.irqLatch = this.irqLatch & 0xFF0F | (value & 0xF) << 4;
                break;
            }
            case 40960: {
                this.irqLatch = this.irqLatch & 0xF0FF | (value & 0xF) << 8;
                break;
            }
            case 45056: {
                this.irqLatch = this.irqLatch & 0xFFF | (value & 0xF) << 12;
                break;
            }
            case 49152: {
                this.writeIrqControl(value);
                break;
            }
            case 53248: {
                this.writeIrqAcknowledge();
                break;
            }
            case 61440: {
                this.setPrgBank(2, value & 7);
            }
        }
    }

    private void writeIrqControl(int value) {
        this.cpu.setMapperIrq(false);
        this.irqEnableOnAck = BitUtil.getBitBool(value, 0);
        this.irqEnabled = BitUtil.getBitBool(value, 1);
        this.irq8bit = BitUtil.getBitBool(value, 2);
        if (this.irqEnabled) {
            this.irqCounter = this.irqLatch;
        }
    }

    private void writeIrqAcknowledge() {
        this.cpu.setMapperIrq(false);
        this.irqEnabled = this.irqEnableOnAck;
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            ++this.irqCounter;
            if (this.irq8bit) {
                if ((this.irqCounter & 0xFF) == 0) {
                    this.irqCounter = this.irqLatch;
                    this.cpu.setMapperIrq(true);
                }
            } else if ((this.irqCounter & 0xFFFF) == 0) {
                this.irqCounter = this.irqLatch;
                this.cpu.setMapperIrq(true);
            }
        }
    }
}

