/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami.vrc7;

import nintaco.files.CartFile;
import nintaco.mappers.konami.VrcIrq;
import nintaco.mappers.konami.vrc7.VRC7Audio;
import nintaco.util.BitUtil;

public class VRC7
extends VrcIrq {
    private static final long serialVersionUID = 0L;
    private final VRC7Audio audio = new VRC7Audio();
    private boolean wramEnabled;

    public VRC7(CartFile cartFile) {
        super(cartFile);
        this.xram = new int[8192];
        this.setPrgBank(7, -1);
        this.audio.init();
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (this.chrRamPresent && address < 8192) {
            this.xram[this.chrBanks[address >> 10] | address & 0x3FF] = value;
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return (this.chrRamPresent ? this.xram : this.chrROM)[this.chrBanks[address >> 10] | address & 0x3FF];
        }
        return this.vram[address];
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (this.audio.writeRegister(address, value)) {
            return;
        }
        switch (address) {
            case 32768: {
                this.writePrgBank(4, value);
                break;
            }
            case 32776: 
            case 32784: {
                this.writePrgBank(5, value);
                break;
            }
            case 36864: {
                this.writePrgBank(6, value);
                break;
            }
            case 40960: {
                this.writeChrBank(0, value);
                break;
            }
            case 40968: 
            case 40976: {
                this.writeChrBank(1, value);
                break;
            }
            case 45056: {
                this.writeChrBank(2, value);
                break;
            }
            case 45064: 
            case 45072: {
                this.writeChrBank(3, value);
                break;
            }
            case 49152: {
                this.writeChrBank(4, value);
                break;
            }
            case 49160: 
            case 49168: {
                this.writeChrBank(5, value);
                break;
            }
            case 53248: {
                this.writeChrBank(6, value);
                break;
            }
            case 53256: 
            case 53264: {
                this.writeChrBank(7, value);
                break;
            }
            case 57344: {
                this.writeMirroring(value);
                break;
            }
            case 57352: 
            case 57360: {
                this.writeIrqLatch(value);
                break;
            }
            case 61440: {
                this.writeIrqControl(value);
                break;
            }
            case 61448: 
            case 61456: {
                this.writeIrqAcknowledge();
            }
        }
    }

    private void writePrgBank(int bank, int value) {
        this.setPrgBank(bank, value & 0x3F);
    }

    private void writeChrBank(int bank, int value) {
        this.chrBanks[bank] = value << 10;
    }

    void writeMirroring(int value) {
        this.writeNametableMirroring(value);
        this.wramEnabled = BitUtil.getBitBool(value, 7);
    }

    private void writeNametableMirroring(int nametableMirroring) {
        this.setNametableMirroring(nametableMirroring &= 3);
    }

    @Override
    public void update() {
        super.update();
        this.audio.update();
    }

    @Override
    public int getAudioMixerScale() {
        return this.audio.getAudioMixerScale();
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }
}

