/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nanjing;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Nanjing
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[4];
    private boolean lastStrobe;
    private boolean trigger;

    public Nanjing(CartFile cartFile) {
        super(cartFile, 2, 2);
    }

    @Override
    public void init() {
        this.lastStrobe = true;
        this.updateBanks();
    }

    private void updateBanks() {
        this.setPrgBank(this.regs[0] << 4 | this.regs[1] & 0xF);
        this.setChrBank(0, 0);
        this.setChrBank(1, 1);
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xF000) == 20480) {
            switch (address & 0x7700) {
                case 20736: {
                    return this.regs[2] | this.regs[0] | this.regs[1] | this.regs[3] ^ 0xFF;
                }
                case 21760: {
                    if (this.trigger) {
                        return this.regs[2] | this.regs[1];
                    }
                    return 0;
                }
            }
            return 4;
        }
        return super.readMemory(address);
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        if (rendering && scanlineCycle == 256 && (this.regs[1] & 0x80) != 0) {
            if (scanline == 239) {
                this.setChrBank(0, 0);
                this.setChrBank(1, 0);
            } else if (scanline == 127) {
                this.setChrBank(0, 1);
                this.setChrBank(1, 1);
            }
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if ((address & 0xF000) == 20480) {
            if (address == 20737) {
                if (this.lastStrobe && value == 0) {
                    this.trigger ^= true;
                }
                this.lastStrobe = value != 0;
            } else if (address == 20736 && value == 6) {
                this.setPrgBank(3);
            } else {
                switch (address & 0x7300) {
                    case 20992: {
                        this.regs[0] = value;
                        this.updateBanks();
                        break;
                    }
                    case 20480: {
                        this.regs[1] = value;
                        this.updateBanks();
                        if ((this.regs[1] & 0x80) != 0 || this.ppu.getScanline() >= 128) break;
                        this.setChrBank(0, 0);
                        this.setChrBank(1, 1);
                        break;
                    }
                    case 21248: {
                        this.regs[2] = value;
                        break;
                    }
                    case 20736: {
                        this.regs[3] = value;
                        this.updateBanks();
                    }
                }
            }
        }
    }
}

