/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class MMC2
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[][] chrRegs = new int[2][2];
    private final int[] latches = new int[2];

    public MMC2(CartFile cartFile) {
        super(cartFile, 8, 2);
    }

    @Override
    public void init() {
        this.setPrgBank(5, -3);
        this.setPrgBank(6, -2);
        this.setPrgBank(7, -1);
    }

    @Override
    public int readVRAM(int address) {
        int value;
        if (address < 8192) {
            int index = address >> 12;
            value = super.readVRAM(address);
            switch (address & 0xFF0) {
                case 4048: {
                    this.latches[index] = 0;
                    this.updateChrBanks();
                    break;
                }
                case 4064: {
                    this.latches[index] = 1;
                    this.updateChrBanks();
                }
            }
        } else {
            value = this.vram[address];
        }
        return value;
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address >= 40960) {
            switch (address & 0xF000) {
                case 40960: {
                    this.setPrgBank(4, value);
                    break;
                }
                case 45056: {
                    this.writeChrReg(0, 0, value);
                    break;
                }
                case 49152: {
                    this.writeChrReg(0, 1, value);
                    break;
                }
                case 53248: {
                    this.writeChrReg(1, 0, value);
                    break;
                }
                case 57344: {
                    this.writeChrReg(1, 1, value);
                    break;
                }
                case 61440: {
                    this.setNametableMirroring(value & 1);
                }
            }
        }
    }

    private void updateChrBanks() {
        this.setChrBank(0, this.chrRegs[0][this.latches[0]]);
        this.setChrBank(1, this.chrRegs[1][this.latches[1]]);
    }

    private void writeChrReg(int i, int j, int value) {
        this.chrRegs[i][j] = value;
        this.updateChrBanks();
    }
}

