/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.CNROM;

public class Mapper185
extends CNROM {
    private static final long serialVersionUID = 0L;
    protected boolean chrEnabled;
    protected boolean seicross;

    public Mapper185(CartFile cartFile) {
        super(cartFile);
        this.seicross = cartFile.getFileCRC() == 252051210 || cartFile.getFileName().contains("seic");
    }

    @Override
    public void init() {
        super.init();
        for (int i = 8191; i >= 0; --i) {
            this.vram[i] = 255;
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        this.setChrBank(0, value & 3);
        int C = value & 0x33;
        this.chrEnabled = this.seicross ? C != 33 : (C & 3) != 0 && C != 19;
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return this.chrEnabled ? super.readVRAM(address) : 255;
        }
        return this.vram[address];
    }
}

