/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC1;
import nintaco.util.BitUtil;

public class NesEvent
extends MMC1 {
    private static final long serialVersionUID = 0L;
    private static final int DIP_SWITCH_SETTING = 4;
    private static final int IRQ_VALUE = 0x28000000;
    private int updatesEnableCounter = 2;
    private int prgRegA;
    private int irqCounter;
    private boolean irqEnabled;
    private boolean prgMode;
    private boolean updatesEnabled;

    public NesEvent(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        super.init();
        this.setPrgBank(2, 0);
        this.setPrgBank(3, 1);
    }

    @Override
    protected void writeChrBankReg(int bank, int value) {
        if (bank == 0) {
            this.irqEnabled = !BitUtil.getBitBool(value, 4);
            this.prgMode = BitUtil.getBitBool(value, 3);
            this.prgRegA = value & 6;
            if (!this.irqEnabled) {
                this.irqCounter = 0;
                this.cpu.setMapperIrq(false);
                if (this.updatesEnableCounter == 1) {
                    this.updatesEnableCounter = 0;
                    this.updatesEnabled = true;
                }
            } else if (this.updatesEnableCounter == 2) {
                this.updatesEnableCounter = 1;
            }
            this.updateBanks();
        }
    }

    @Override
    protected void writePrgBankReg(int value) {
        this.prgBankReg = value & 7 | 8;
        this.prgRamEnabled = !BitUtil.getBitBool(value, 4);
        this.updateBanks();
    }

    @Override
    public void update() {
        if (this.irqEnabled && ++this.irqCounter == 0x28000000) {
            this.cpu.setMapperIrq(true);
            this.irqEnabled = false;
            this.irqCounter = 0;
        }
    }

    @Override
    protected void updateBanks() {
        if (this.updatesEnabled) {
            if (this.prgMode) {
                super.updateBanks();
            } else {
                this.setPrgBank(2, this.prgRegA);
                this.setPrgBank(3, this.prgRegA | 1);
            }
        }
    }
}

