/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.mmc5;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.mmc5.MMC5Audio;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;

public class MMC5
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final boolean[] prgRamBanks = new boolean[8];
    private final int[] prgRegs = new int[4];
    private final int[] chrRegs = new int[12];
    private final int[][] cBanks = new int[2][8];
    private final int[][] cRegs = new int[2][8];
    private final MMC5Audio audio = new MMC5Audio(this);
    private int prgMode;
    private int chrMode;
    private int nametableOffset;
    private int patternTableBlock;
    private int backgroundTileX = -1;
    private int backgroundTileSkip = 2;
    private int extendedRamMode;
    private int fillModeTile;
    private int fillModeAttribute;
    private int upperChrBits;
    private int verticalSplitTile;
    private int verticalSplitScrollValue;
    private int verticalSplitBank;
    private int verticalFetch;
    private int verticalOffset;
    private int irqCounter;
    private int irqScanline;
    private boolean irqPending;
    private boolean irqEnabled;
    private boolean prgRamWriteProtect1;
    private boolean prgRamWriteProtect2;
    private boolean prgRamWriteEnabled;
    private boolean useLowerChrRegs;
    private boolean inFrame;
    private boolean verticalSplitEnabled;
    private boolean verticalSplitRightSide;
    private boolean spriteTile;

    public MMC5(CartFile cartFile) {
        super(cartFile, 8, 8);
        this.xram = new int[65536];
        this.prgRamBanks[3] = true;
        this.nametableMappingEnabled = false;
    }

    @Override
    public void init() {
        int i;
        this.chrBanks = this.cBanks[0];
        this.writePrgMode(3);
        for (i = 3; i >= 0; --i) {
            this.writePrgReg(i, 255);
        }
        for (i = this.cBanks.length - 1; i >= 0; --i) {
            for (int j = this.cBanks[i].length - 1; j >= 0; --j) {
                this.setChrBank(i, j, j);
            }
        }
        this.writeChrMode(0);
        this.audio.init();
    }

    @Override
    public void setTVSystem(TVSystem tvSystem) {
        super.setTVSystem(tvSystem);
        this.audio.setTVSystem(tvSystem);
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            if (this.inFrame && this.verticalFetch > 0 && !this.spriteTile) {
                --this.verticalFetch;
                return this.chrROM[(this.verticalSplitBank | address & 0xFF8 | this.verticalOffset & 7) & this.chrRomSizeMask];
            }
            if (this.inFrame && this.extendedRamMode == 1 && !this.spriteTile) {
                return this.chrROM[(this.upperChrBits << 18 | this.patternTableBlock | address & 0xFFF) & this.chrRomSizeMask];
            }
            return super.readVRAM(address);
        }
        if (address < 12288) {
            boolean isAttribute;
            int offset = address & 0x3FF;
            boolean bl = isAttribute = offset >= 960;
            if (this.inFrame && !this.spriteTile) {
                if (this.extendedRamMode == 1) {
                    if (isAttribute) {
                        int exramValue = this.memory[0x5C00 | this.nametableOffset];
                        int attribute = exramValue >> 6;
                        attribute |= attribute << 2;
                        attribute |= attribute << 4;
                        this.patternTableBlock = (exramValue & 0x3F) << 12;
                        return attribute;
                    }
                    this.nametableOffset = offset;
                }
                if (!isAttribute) {
                    if (this.backgroundTileX == 2 && this.backgroundTileSkip > 0) {
                        --this.backgroundTileSkip;
                    } else {
                        ++this.backgroundTileX;
                    }
                }
                if (this.verticalSplitEnabled && this.extendedRamMode < 2 && (this.verticalSplitRightSide && this.backgroundTileX >= this.verticalSplitTile || !this.verticalSplitRightSide && this.backgroundTileX < this.verticalSplitTile)) {
                    if (isAttribute) {
                        this.verticalFetch = 2;
                        return this.memory[24512 + (this.backgroundTileX >> 2) + (this.verticalOffset >> 5 << 3)];
                    }
                    return this.memory[23552 + this.backgroundTileX + (this.verticalOffset >> 3 << 5)];
                }
            }
            switch (this.nametableMappings[address >> 10 & 3]) {
                case 0: {
                    return this.vram[0x2000 | offset];
                }
                case 1: {
                    return this.vram[0x2400 | offset];
                }
                case 2: {
                    if (this.extendedRamMode < 2) {
                        return this.memory[0x5C00 | offset];
                    }
                    return 0;
                }
            }
            return isAttribute ? this.fillModeAttribute : this.fillModeTile;
        }
        return this.vram[address];
    }

    @Override
    public int peekVRAM(int address) {
        if (address < 8192) {
            if (this.inFrame && this.verticalFetch > 0 && !this.spriteTile) {
                return this.chrROM[(this.verticalSplitBank | address & 0xFF8 | this.verticalOffset & 7) & this.chrRomSizeMask];
            }
            if (this.inFrame && this.extendedRamMode == 1 && !this.spriteTile) {
                return this.chrROM[(this.upperChrBits << 18 | this.patternTableBlock | address & 0xFFF) & this.chrRomSizeMask];
            }
            return super.readVRAM(address);
        }
        if (address < 12288) {
            boolean isAttribute;
            int offset = address & 0x3FF;
            boolean bl = isAttribute = offset >= 960;
            if (this.inFrame && !this.spriteTile) {
                if (this.extendedRamMode == 1) {
                    if (isAttribute) {
                        int exramValue = this.memory[0x5C00 | this.nametableOffset];
                        int attribute = exramValue >> 6;
                        attribute |= attribute << 2;
                        attribute |= attribute << 4;
                        this.patternTableBlock = (exramValue & 0x3F) << 12;
                        return attribute;
                    }
                    this.nametableOffset = offset;
                }
                if (this.verticalSplitEnabled && this.extendedRamMode < 2 && (this.verticalSplitRightSide && this.backgroundTileX >= this.verticalSplitTile || !this.verticalSplitRightSide && this.backgroundTileX < this.verticalSplitTile)) {
                    if (isAttribute) {
                        return this.memory[24512 + (this.backgroundTileX >> 2) + (this.verticalOffset >> 5 << 3)];
                    }
                    return this.memory[23552 + this.backgroundTileX + (this.verticalOffset >> 3 << 5)];
                }
            }
            switch (this.nametableMappings[address >> 10 & 3]) {
                case 0: {
                    return this.vram[0x2000 | offset];
                }
                case 1: {
                    return this.vram[0x2400 | offset];
                }
                case 2: {
                    if (this.extendedRamMode < 2) {
                        return this.memory[0x5C00 | offset];
                    }
                    return 0;
                }
            }
            return isAttribute ? this.fillModeAttribute : this.fillModeTile;
        }
        return this.vram[address];
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address >= 8192 && address < 12288) {
            switch (this.nametableMappings[address >> 10 & 3]) {
                case 0: {
                    this.vram[0x2000 | address & 0x3FF] = value;
                    break;
                }
                case 1: {
                    this.vram[0x2400 | address & 0x3FF] = value;
                    break;
                }
                case 2: {
                    this.memory[0x5C00 | address & 0x3FF] = value;
                }
            }
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    public int readMemory(int address) {
        if (address >= 24576) {
            int bank = address >> this.prgShift;
            int addr = this.prgBanks[bank] | address & this.prgAddressMask;
            int value = this.prgRamBanks[bank] ? this.xram[addr & 0xFFFF] : this.prgROM[addr & this.prgRomSizeMask];
            this.audio.updatePcmValue(address, value);
            return value;
        }
        int value = this.audio.readRegister(address);
        if (value >= 0) {
            return value;
        }
        if (address == 20996) {
            return this.readIrqStatus();
        }
        if (address >= 23552) {
            if (this.extendedRamMode < 2) {
                return 0;
            }
            return this.memory[address];
        }
        return this.memory[address];
    }

    @Override
    public void writeCpuMemory(int address, int value) {
        super.writeCpuMemory(address, value);
        if ((address & 0xE007) == 8193 && (value & 0x18) == 0) {
            this.irqCounter = -2;
            this.inFrame = false;
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if (this.audio.writeRegister(address, value)) {
            return;
        }
        switch (address) {
            case 20736: {
                this.writePrgMode(value);
                break;
            }
            case 20737: {
                this.writeChrMode(value);
                break;
            }
            case 20738: {
                this.writePrgRamWriteProtect1(value);
                break;
            }
            case 20739: {
                this.writePrgRamWriteProtect2(value);
                break;
            }
            case 20740: {
                this.writeExtendedRamMode(value);
                break;
            }
            case 20741: {
                this.writeNametableMapping(value);
                break;
            }
            case 20742: {
                this.writeFillModeTile(value);
                break;
            }
            case 20743: {
                this.writeFillModeAttribute(value);
                break;
            }
            case 20755: {
                this.writePrgRamBank(value);
                break;
            }
            case 20756: {
                this.writePrgReg(0, value);
                break;
            }
            case 20757: {
                this.writePrgReg(1, value);
                break;
            }
            case 20758: {
                this.writePrgReg(2, value);
                break;
            }
            case 20759: {
                this.writePrgReg(3, value);
                break;
            }
            case 20768: 
            case 20769: 
            case 20770: 
            case 20771: 
            case 20772: 
            case 20773: 
            case 20774: 
            case 20775: 
            case 20776: 
            case 20777: 
            case 20778: 
            case 20779: {
                this.writeChrReg(address & 0xF, value);
                break;
            }
            case 20784: {
                this.writeUpperChrBits(value);
                break;
            }
            case 20992: {
                this.writeVerticalSplitMode(value);
                break;
            }
            case 20993: {
                this.writeVerticalSplitScroll(value);
                break;
            }
            case 20994: {
                this.writeVerticalSplitBank(value);
                break;
            }
            case 20995: {
                this.writeIrqScanline(value);
                break;
            }
            case 20996: {
                this.writeIrqStatus(value);
                break;
            }
            default: {
                this.writeToBanks(address, value);
            }
        }
    }

    private void writeToBanks(int address, int value) {
        int bank;
        if (address < 24576) {
            if (address >= 23552) {
                if (this.extendedRamMode < 2) {
                    this.memory[address] = this.inFrame ? value : 0;
                } else if (this.extendedRamMode == 2) {
                    this.memory[address] = value;
                }
            } else {
                this.memory[address] = value;
            }
        } else if (this.prgRamWriteEnabled && this.prgRamBanks[bank = address >> this.prgShift]) {
            this.xram[(this.prgBanks[bank] | address & this.prgAddressMask) & 0xFFFF] = value;
        }
    }

    private void writePrgMode(int value) {
        this.prgMode = value & 3;
        this.updatePrgBanks();
    }

    private void writeChrMode(int value) {
        this.chrMode = value & 3;
        this.updateChrBanks();
    }

    private void writePrgRamWriteProtect1(int value) {
        this.prgRamWriteProtect1 = (value & 3) == 2;
        this.updatePrgRamWriteProtection();
    }

    private void writePrgRamWriteProtect2(int value) {
        this.prgRamWriteProtect2 = (value & 3) == 1;
        this.updatePrgRamWriteProtection();
    }

    private void writeExtendedRamMode(int value) {
        this.extendedRamMode = value & 3;
    }

    private void writeNametableMapping(int value) {
        for (int i = 3; i >= 0; --i) {
            this.nametableMappings[i] = value >> (i << 1) & 3;
        }
    }

    private void writeFillModeTile(int value) {
        this.fillModeTile = value;
    }

    private void writeFillModeAttribute(int value) {
        this.fillModeAttribute = value & 3;
        this.fillModeAttribute |= this.fillModeAttribute << 2;
        this.fillModeAttribute |= this.fillModeAttribute << 4;
    }

    private void writePrgRamBank(int value) {
        this.setPrgBank(3, value & 7);
    }

    private void writePrgReg(int register, int value) {
        this.prgRegs[register] = value;
        this.updatePrgBanks();
    }

    private void writeChrReg(int register, int value) {
        this.chrRegs[register] = value;
        this.useLowerChrRegs = register < 8;
        this.updateChrBanks();
    }

    private void writeUpperChrBits(int value) {
        this.upperChrBits = value & 3;
        this.updateChrBanks();
    }

    private void writeVerticalSplitMode(int value) {
        this.verticalSplitEnabled = BitUtil.getBitBool(value, 7);
        this.verticalSplitRightSide = BitUtil.getBitBool(value, 6);
        this.verticalSplitTile = value & 0x1F;
    }

    private void writeVerticalSplitScroll(int value) {
        this.verticalSplitScrollValue = value;
    }

    private void writeVerticalSplitBank(int value) {
        this.verticalSplitBank = value << 12;
    }

    private void writeIrqScanline(int value) {
        this.irqScanline = value;
    }

    private void writeIrqStatus(int value) {
        this.irqEnabled = BitUtil.getBitBool(value, 7);
        this.updateIrq();
    }

    private int readIrqStatus() {
        int value = 0;
        if (this.irqPending) {
            value |= 0x80;
        }
        if (this.inFrame) {
            value |= 0x40;
        }
        this.irqPending = false;
        this.updateIrq();
        return value;
    }

    private void updatePrgBanks() {
        switch (this.prgMode) {
            case 0: {
                int bank4 = this.setPrg(4, 3, 124);
                this.setPrgBank(5, bank4 | 1);
                this.setPrgBank(6, bank4 | 2);
                this.setPrgBank(7, bank4 | 3);
                this.prgRamBanks[7] = false;
                this.prgRamBanks[6] = false;
                this.prgRamBanks[5] = false;
                break;
            }
            case 1: {
                this.setPrgBank(5, this.setPrg(4, 1, 126) | 1);
                this.prgRamBanks[5] = this.prgRamBanks[4];
                this.setPrgBank(7, this.setPrg(6, 3, 126) | 1);
                this.prgRamBanks[7] = false;
                break;
            }
            case 2: {
                this.setPrgBank(5, this.setPrg(4, 1, 126) | 1);
                this.prgRamBanks[5] = this.prgRamBanks[4];
                this.setPrg(6, 2);
                this.setPrg(7, 3);
                break;
            }
            case 3: {
                this.setPrg(4, 0);
                this.setPrg(5, 1);
                this.setPrg(6, 2);
                this.setPrg(7, 3);
            }
        }
    }

    private int setPrg(int bank, int register) {
        return this.setPrg(bank, register, 127);
    }

    private int setPrg(int bank, int register, int mask) {
        int value = this.prgRegs[register] & mask;
        boolean bl = this.prgRamBanks[bank] = register != 3 && !BitUtil.getBitBool(this.prgRegs[register], 7);
        if (this.prgRamBanks[bank]) {
            value &= 7;
        }
        this.setPrgBank(bank, value);
        return value;
    }

    private void updateChrBanks() {
        if (this.inFrame && this.ppu.isSpriteSize8x16()) {
            System.arraycopy(this.chrRegs, 0, this.cRegs[0], 0, 8);
            System.arraycopy(this.chrRegs, 8, this.cRegs[1], 0, 4);
            System.arraycopy(this.chrRegs, 8, this.cRegs[1], 4, 4);
        } else if (this.useLowerChrRegs) {
            System.arraycopy(this.chrRegs, 0, this.cRegs[0], 0, 8);
            System.arraycopy(this.chrRegs, 0, this.cRegs[1], 0, 8);
        } else {
            System.arraycopy(this.chrRegs, 8, this.cRegs[0], 0, 4);
            System.arraycopy(this.chrRegs, 8, this.cRegs[0], 4, 4);
            System.arraycopy(this.chrRegs, 8, this.cRegs[1], 0, 4);
            System.arraycopy(this.chrRegs, 8, this.cRegs[1], 4, 4);
        }
        int upper = this.upperChrBits << 8;
        block6: for (int i = 1; i >= 0; --i) {
            switch (this.chrMode) {
                case 0: {
                    int bank = (upper | this.cRegs[i][7]) << 3;
                    for (int j = 7; j >= 0; --j) {
                        this.setChrBank(i, j, bank | j);
                    }
                    continue block6;
                }
                case 1: {
                    int bank;
                    int j;
                    for (j = 7; j >= 0; j -= 4) {
                        bank = (upper | this.cRegs[i][j]) << 2;
                        this.setChrBank(i, j - 3, bank);
                        this.setChrBank(i, j - 2, bank | 1);
                        this.setChrBank(i, j - 1, bank | 2);
                        this.setChrBank(i, j, bank | 3);
                    }
                    continue block6;
                }
                case 2: {
                    int bank;
                    int j;
                    for (j = 7; j >= 0; j -= 2) {
                        bank = (upper | this.cRegs[i][j]) << 1;
                        this.setChrBank(i, j - 1, bank);
                        this.setChrBank(i, j, bank | 1);
                    }
                    continue block6;
                }
                case 3: {
                    int j;
                    for (j = 7; j >= 0; --j) {
                        this.setChrBank(i, j, upper | this.cRegs[i][j]);
                    }
                    continue block6;
                }
            }
        }
    }

    private void setChrBank(int index, int bank, int value) {
        this.cBanks[index][bank] = value << this.chrShift;
    }

    private void updatePrgRamWriteProtection() {
        this.prgRamWriteEnabled = this.prgRamWriteProtect1 && this.prgRamWriteProtect2;
    }

    void updateIrq() {
        this.cpu.setMapperIrq(this.irqEnabled && this.irqPending || this.audio.isIrq());
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        if (scanline == 240 && scanlineCycle == 0) {
            this.irqCounter = -2;
            this.inFrame = false;
            this.updateChrBanks();
        }
        if (rendering) {
            switch (scanlineCycle) {
                case 0: {
                    switch (scanline) {
                        case 0: {
                            this.irqPending = false;
                            break;
                        }
                        case 1: {
                            this.inFrame = true;
                        }
                    }
                    ++this.irqCounter;
                    if (this.irqScanline != 0 && this.irqCounter == this.irqScanline) {
                        this.irqPending = true;
                    }
                    this.updateIrq();
                    break;
                }
                case 256: {
                    this.chrBanks = this.cBanks[0];
                    this.spriteTile = true;
                    this.updateChrBanks();
                    break;
                }
                case 320: {
                    this.chrBanks = this.cBanks[1];
                    this.spriteTile = false;
                    this.backgroundTileX = -1;
                    this.backgroundTileSkip = 2;
                    if (scanline == -1) {
                        this.verticalOffset = this.verticalSplitScrollValue;
                        if (this.verticalOffset >= 240) {
                            this.verticalOffset -= 16;
                        }
                    } else if (scanline < 240) {
                        ++this.verticalOffset;
                    }
                    if (this.verticalOffset >= 240) {
                        this.verticalOffset -= 240;
                    }
                    this.updateChrBanks();
                }
            }
        }
    }

    @Override
    public void update() {
        this.audio.update();
    }

    @Override
    public int getAudioMixerScale() {
        return this.audio.getAudioMixerScale();
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }
}

