/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.mmc5;

import java.io.Serializable;
import nintaco.apu.APU;
import nintaco.apu.EnvelopeGenerator;
import nintaco.util.BitUtil;

public class MMC5PulseGenerator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int[][] waveforms = new int[][]{{0, 1, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0, 0}, {1, 0, 0, 1, 1, 1, 1, 1}};
    private int duty;
    private int timer;
    private int timerReload;
    private int waveformIndex;
    private int lengthCounter;
    private boolean lengthCounterEnabled;
    private boolean enabled;
    private final EnvelopeGenerator envelopeGenerator = new EnvelopeGenerator();

    public void reset() {
        this.duty = 0;
        this.timer = 0;
        this.timerReload = 0;
        this.waveformIndex = 0;
        this.lengthCounter = 0;
        this.lengthCounterEnabled = false;
        this.enabled = false;
        this.envelopeGenerator.reset();
    }

    public void writeEnvelope(int value) {
        this.envelopeGenerator.write(value);
        this.lengthCounterEnabled = !BitUtil.getBitBool(value, 5);
        this.duty = value >> 6 & 3;
    }

    public void writeTimerReloadLow(int value) {
        this.timerReload = this.timerReload & 0x700 | value;
    }

    public void writeTimerReloadHigh(int value) {
        if (this.enabled) {
            this.lengthCounter = APU.lengths[value >> 3];
        }
        this.timerReload = this.timerReload & 0xFF | (value & 7) << 8;
        this.waveformIndex = 0;
        this.envelopeGenerator.setStart(true);
    }

    public void updateEnvelopeGeneratorAndLengthCounter() {
        this.envelopeGenerator.update();
        if (this.lengthCounterEnabled && this.lengthCounter > 0) {
            --this.lengthCounter;
        }
    }

    public void update() {
        if (this.timer == 0) {
            this.timer = this.timerReload;
            this.waveformIndex = this.waveformIndex - 1 & 7;
        } else {
            --this.timer;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.lengthCounter = 0;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getLengthCounter() {
        return this.lengthCounter;
    }

    public int getValue() {
        if (this.lengthCounter == 0) {
            return 0;
        }
        return waveforms[this.duty][this.waveformIndex] == 0 ? 0 : this.envelopeGenerator.getVolume();
    }
}

