/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.vs;

import java.io.IOException;
import java.io.ObjectInputStream;
import nintaco.CPU;
import nintaco.PPU;
import nintaco.ScreenRenderer;
import nintaco.apu.APU;
import nintaco.mappers.nintendo.vs.DualAPU;
import nintaco.mappers.nintendo.vs.SubVsDualSystem;
import nintaco.tv.TVSystem;

public class MainCPU
extends CPU {
    private static final long serialVersionUID = 0L;
    private transient int[] screen = new int[61440];
    private final CPU subCPU = new CPU();
    private final PPU subPPU = new PPU();
    private final APU subAPU = new DualAPU();

    public MainCPU(SubVsDualSystem subVsDualSystem) {
        subVsDualSystem.setTVSystem(TVSystem.NTSC);
        this.subCPU.setMapper(subVsDualSystem);
        this.subCPU.setPPU(this.subPPU);
        this.subCPU.setAPU(this.subAPU);
        this.subPPU.setMapper(subVsDualSystem);
        this.subPPU.setTVSystem(TVSystem.NTSC);
        this.subPPU.setCPU(this.subCPU);
        this.clearScreenRenderer();
        this.subAPU.setCPU(this.subCPU);
        this.subAPU.getDMC().setCPU(this.subCPU);
        this.subAPU.setMapper(subVsDualSystem);
        this.subAPU.getDMC().setPAL(false);
        this.subAPU.setTVSystem(TVSystem.NTSC);
        this.subAPU.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.subCPU.reset();
    }

    @Override
    public void executeInstruction() {
        super.executeInstruction();
        long mainCycleCounter = this.getCycleCounter() - 16L;
        while (this.subCPU.getCycleCounter() < mainCycleCounter) {
            this.subCPU.executeInstruction();
        }
    }

    public CPU getSubCPU() {
        return this.subCPU;
    }

    public PPU getSubPPU() {
        return this.subPPU;
    }

    public APU getSubAPU() {
        return this.subAPU;
    }

    public void clearScreenRenderer() {
        this.setScreenRenderer(null);
    }

    public void setScreenRenderer(ScreenRenderer screenRenderer) {
        if (screenRenderer == null) {
            this.subPPU.setScreenRenderer(() -> this.screen);
        } else {
            this.subPPU.setScreenRenderer(screenRenderer);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.screen = new int[61440];
        this.subPPU.setScreenRenderer(() -> this.screen);
    }
}

