/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.nintendo.vs;

import java.util.ArrayList;
import java.util.List;
import nintaco.files.NesFile;
import nintaco.input.dipswitches.DipSwitch;

public enum VsGame {
    BalloonFight(99, 4, 4, 5, false, false),
    Baseball(99, 4, 2, 5, false, false),
    IceClimberDual(99, 4, 5, 5, true, false),
    Mahjong(99, 4, 0, 5, false, false),
    RaidOnBungelingBay(99, 4, 3, 6, true, false),
    Tennis(99, 4, 0, 5, false, false),
    WreckingCrew(99, 4, 3, 5, false, false),
    BattleCity(99, 4, 2, 0, false, false),
    Castlevania(2, 0, 3, 0, false, false),
    CluCluLand(99, 4, 5, 0, true, false),
    DrMario(1, 1, 4, 0, true, false),
    DuckHunt(99, 4, 0, 0, false, true),
    Excitebike(99, 4, 4, 0, false, false),
    ExcitebikeJapan(99, 4, 5, 0, false, false),
    FreedomForce(4, 0, 2, 0, false, true),
    Goonies(75, 4, 4, 0, false, false),
    Gradius(75, 4, 2, 0, true, false),
    Gumshoe(99, 4, 10, 0, false, true, 28),
    HogansAlley(99, 4, 2, 0, false, true),
    IceClimber(99, 4, 5, 0, true, false),
    IceClimber_2(99, 4, 5, 4, true, false),
    LadiesGolf(99, 4, 3, 0, true, false),
    MachRider(99, 4, 3, 0, false, false),
    MachRider_2(99, 4, 2, 0, false, false),
    MachRiderJapan(99, 4, 2, 0, false, false),
    MightyBombJack(0, 4, 9, 0, false, false, 61),
    NinjaJajamaruKun(99, 4, 8, 0, true, false),
    Pinball(99, 4, 2, 0, false, false),
    PinballJapan(99, 4, 0, 0, false, false),
    Platoon(68, 0, 2, 0, false, false),
    RbiBaseball(206, 0, 3, 1, true, false),
    RbiBaseball_2(206, 0, 2, 1, true, false),
    SkateKids(99, 4, 5, 0, false, false),
    Slalom(0, 4, 3, 0, false, false),
    Soccer(99, 4, 4, 0, true, false),
    Soccer_2(99, 4, 3, 0, true, false),
    StarLuster(99, 4, 0, 0, false, false),
    StrokeAndMatchGolf(99, 4, 3, 0, true, false),
    StrokeAndMatchGolfJapan(99, 4, 0, 0, true, false),
    SuperMarioBros(99, 4, 5, 0, false, false),
    SuperSkyKid(206, 0, 3, 0, true, false),
    SuperXevious(206, 1, 3, 3, false, false),
    Tetris(99, 4, 3, 0, true, false),
    TkoBoxing(206, 0, 0, 2, false, false),
    TopGun(2, 1, 11, 0, false, false, 27);

    private static final Object[][] NameMappings;
    private final List<DipSwitch> dipSwitches = new ArrayList<DipSwitch>();
    private final int mapper;
    private final int mirroring;
    private final int ppu;
    private final int hardware;
    private final boolean swapControllers;
    private final boolean zapperGame;
    private final int ppuStatusID;

    private VsGame(int mapper, int mirroring, int ppu, int hardware, boolean swapControllers, boolean zapperGame) {
        this(mapper, mirroring, ppu, hardware, swapControllers, zapperGame, 0);
    }

    private VsGame(int mapper, int mirroring, int ppu, int hardware, boolean swapControllers, boolean zapperGame, int ppuStatusID) {
        this.mapper = mapper;
        this.mirroring = mirroring;
        this.ppu = ppu;
        this.hardware = hardware;
        this.swapControllers = swapControllers;
        this.zapperGame = zapperGame;
        this.ppuStatusID = ppuStatusID;
    }

    private void addAll(List<DipSwitch> dipSwitches) {
        this.dipSwitches.addAll(dipSwitches);
    }

    private DipSwitch add(String name) {
        return this.add(name, 0);
    }

    private DipSwitch add(String name, int defaultValue) {
        DipSwitch dipSwitch = new DipSwitch(name, defaultValue);
        this.dipSwitches.add(dipSwitch);
        return dipSwitch;
    }

    public List<DipSwitch> getDipSwitches() {
        return this.dipSwitches;
    }

    public int getMapper() {
        return this.mapper;
    }

    public int getMirroring() {
        return this.mirroring;
    }

    public int getPPU() {
        return this.ppu;
    }

    public int getHardware() {
        return this.hardware;
    }

    public boolean isNonVolatilePrgRamPresent() {
        return this.isDualSystemGame() && this != Mahjong && this != RaidOnBungelingBay;
    }

    public boolean isProtected() {
        return this.hardware == 4 || this.hardware == 6;
    }

    public boolean isSwapControllers() {
        return this.swapControllers;
    }

    public boolean isZapperGame() {
        return this.zapperGame;
    }

    public int getPpuStatusID() {
        return this.ppuStatusID;
    }

    public boolean isUniSystemGame() {
        return this.hardware < 5;
    }

    public boolean isDualSystemGame() {
        return this.hardware >= 5;
    }

    public static VsGame getVsGame(NesFile nesFile) {
        switch (nesFile.getFileCRC()) {
            case 740083418: {
                return BalloonFight;
            }
            case -1575800578: 
            case -625540137: 
            case 952225858: 
            case 1466457708: {
                return Baseball;
            }
            case -1300141063: 
            case -1076331512: 
            case 20281668: {
                return BattleCity;
            }
            case -1162617415: 
            case -4263052: {
                return Castlevania;
            }
            case 262349506: {
                return CluCluLand;
            }
            case 730153486: {
                return DrMario;
            }
            case -1411276606: 
            case -1042923233: {
                return DuckHunt;
            }
            case -917298776: 
            case -261109726: {
                return Excitebike;
            }
            case -82977305: {
                return ExcitebikeJapan;
            }
            case -2094205550: {
                return FreedomForce;
            }
            case -153212254: 
            case 228519934: 
            case 1580576029: 
            case 1962349492: {
                return Goonies;
            }
            case -292883182: 
            case -147465946: 
            case 1069481329: {
                return Gradius;
            }
            case -1315648896: 
            case 5688479: 
            case 128119730: 
            case 1093556749: 
            case 1959235212: 
            case 2088601114: {
                return Gumshoe;
            }
            case -1021819477: 
            case 380259885: {
                return HogansAlley;
            }
            case -876675809: 
            case -277155016: 
            case 852327906: {
                return IceClimber;
            }
            case 480533101: {
                return IceClimber_2;
            }
            case 1607923203: {
                return IceClimberDual;
            }
            case -390987369: 
            case -376796595: {
                return MachRider;
            }
            case -1410801292: {
                return MachRider_2;
            }
            case -557829881: 
            case 1372023107: 
            case 2032988543: {
                return Mahjong;
            }
            case 1398694226: {
                return MightyBombJack;
            }
            case -1039229785: {
                return NinjaJajamaruKun;
            }
            case -901866726: {
                return Pinball;
            }
            case 1715937022: {
                return PinballJapan;
            }
            case 171370446: 
            case 538574437: 
            case 828867601: {
                return Platoon;
            }
            case -103069763: 
            case 1895806353: {
                return RaidOnBungelingBay;
            }
            case 623599185: {
                return RbiBaseball;
            }
            case -2093489885: 
            case -464222811: {
                return RbiBaseball_2;
            }
            case 1089405182: {
                return SkateKids;
            }
            case -1696417120: {
                return Slalom;
            }
            case 1986800812: {
                return Soccer;
            }
            case -496659487: {
                return Soccer_2;
            }
            case 362738625: {
                return StarLuster;
            }
            case -2003172695: 
            case -1312504568: 
            case -396593960: 
            case 500052449: 
            case 1211506297: 
            case 1672214665: {
                return StrokeAndMatchGolf;
            }
            case -1754733088: {
                return StrokeAndMatchGolfJapan;
            }
            case -1729902758: 
            case 477376761: 
            case 1266281859: 
            case 1274255149: 
            case 2097090436: {
                return SuperMarioBros;
            }
            case 564548551: {
                return SuperSkyKid;
            }
            case -1984599975: 
            case -553139709: 
            case 302066905: {
                return SuperXevious;
            }
            case -855270678: 
            case 119324683: 
            case 1740292434: {
                return Tennis;
            }
            case -1362453182: 
            case -997018415: 
            case -374935171: 
            case 1802445890: {
                return Tetris;
            }
            case -1945358859: {
                return TopGun;
            }
            case 1388642768: {
                return TkoBoxing;
            }
            case 737288031: {
                return WreckingCrew;
            }
        }
        String fileName = nesFile.getFileName();
        if (fileName.contains("(vs)") || nesFile.isVsSystem()) {
            for (int i = 0; i < NameMappings.length; ++i) {
                Object[] mapping = NameMappings[i];
                if (!fileName.contains((String)mapping[0])) continue;
                VsGame game = (VsGame)((Object)mapping[1]);
                switch (game) {
                    case Excitebike: {
                        if (!VsGame.isJapan(fileName)) break;
                        return ExcitebikeJapan;
                    }
                    case MachRider: {
                        if (!VsGame.isJapan(fileName)) break;
                        return MachRiderJapan;
                    }
                    case Pinball: {
                        if (!VsGame.isJapan(fileName)) break;
                        return PinballJapan;
                    }
                    case StrokeAndMatchGolf: {
                        if (!VsGame.isJapan(fileName)) break;
                        return StrokeAndMatchGolfJapan;
                    }
                }
                return game;
            }
        }
        return null;
    }

    private static boolean isJapan(String fileName) {
        return fileName.contains("(j)") || fileName.contains("(japan") || fileName.contains("(as)") || fileName.contains("(asia");
    }

    static {
        BalloonFight.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        BalloonFight.add("Unused").add("Off", 0).add("On", 8);
        BalloonFight.add("Unused").add("Off", 0).add("On", 16);
        BalloonFight.add("Unused").add("Off", 0).add("On", 32);
        BalloonFight.add("Unused").add("Off", 0).add("On", 64);
        BalloonFight.add("Mode").add("Game", 0).add("Test", 128);
        BalloonFight.add("Lives").add("3", 0).add("4", 512).add("5", 256).add("6", 768);
        BalloonFight.add("Difficulty", 1).add("Easy", 0).add("Normal", 2048).add("Medium", 1024).add("Hard", 3072);
        BalloonFight.add("Enemy Regeneration").add("Low", 0).add("High", 4096);
        BalloonFight.add("Bonus", 1).add("10k", 24576).add("20k", 8192).add("40k", 16384).add("None", 0);
        BalloonFight.add("Unused").add("Off", 0).add("On", 32768);
        Baseball.add("Player Defense Strength", 1).add("Weak", 0).add("Normal", 2).add("Medium", 1).add("Strong", 3);
        Baseball.add("Player Offense Strength", 1).add("Weak", 0).add("Normal", 8).add("Medium", 4).add("Strong", 12);
        Baseball.add("Computer Defense Strength", 1).add("Weak", 0).add("Normal", 32).add("Medium", 16).add("Strong", 48);
        Baseball.add("Computer Offense Strength", 1).add("Weak", 0).add("Normal", 128).add("Medium", 64).add("Strong", 192);
        Baseball.add("Mode").add("Game", 0).add("Test", 256);
        Baseball.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 1024).add("2 Coins / 1 Credit", 512).add("Free Play", 1536);
        Baseball.add("Starting Points").add("80", 0).add("100", 8192).add("150", 4096).add("200", 12288).add("250", 2048).add("300", 10240).add("350", 6144).add("400", 14336);
        Baseball.add("Bonus Play", 1).add("Off", 16384).add("On", 0);
        Baseball.add("Demo Sounds", 1).add("Off", 0).add("On", 32768);
        BattleCity.add("Credits for 2 Players", 1).add("1", 0).add("2", 1);
        BattleCity.add("Lives").add("3", 0).add("5", 2);
        BattleCity.add("Demo Sounds", 1).add("Off", 0).add("On", 4);
        BattleCity.add("Unknown/Unused").add("Off", 0).add("On", 8);
        BattleCity.add("Unknown/Unused").add("Off", 0).add("On", 16);
        BattleCity.add("Unknown/Unused").add("Off", 0).add("On", 32);
        BattleCity.add("PPU").add("RP2C04-0001", 0).add("RP2C04-0002", 64).add("RP2C04-0003", 128).add("RP2C04-0004", 192);
        Castlevania.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("2 Coins / 1 Credit", 6).add("3 Coins / 1 Credit", 1).add("4 Coins / 1 Credit", 5).add("5 Coins / 1 Credit", 3).add("Free Play", 7);
        Castlevania.add("Lives", 1).add("2", 8).add("3", 0);
        Castlevania.add("Bonus").add("100k", 0).add("200k", 32).add("300k", 16).add("400k", 48);
        Castlevania.add("Difficulty").add("Normal", 0).add("Hard", 64);
        CluCluLand.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        CluCluLand.add("Unknown/Unused").add("Off", 0).add("On", 8);
        CluCluLand.add("Unknown/Unused").add("Off", 0).add("On", 16);
        CluCluLand.add("Lives", 1).add("2", 96).add("3", 0).add("4", 64).add("5", 32);
        CluCluLand.add("Unknown/Unused").add("Off", 0).add("On", 128);
        DrMario.add("Drop Rate Increases After").add("7 Pills", 0).add("8 Pills", 1).add("9 Pills", 2).add("10 Pills", 3);
        DrMario.add("Virus Level").add("1", 0).add("3", 4).add("5", 8).add("7", 12);
        DrMario.add("Drop Speed Up").add("Slow", 0).add("Medium", 16).add("Fast", 32).add("Fastest", 48);
        DrMario.add("Free Play").add("Off", 0).add("On", 64);
        DrMario.add("Demo Sounds", 1).add("Off", 0).add("On", 128);
        DuckHunt.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("2 Coins / 1 Credit", 6).add("3 Coins / 1 Credit", 1).add("4 Coins / 1 Credit", 5).add("5 Coins / 1 Credit", 3).add("Free Play", 7);
        DuckHunt.add("Difficulty", 1).add("Easy", 0).add("Normal", 8).add("Hard", 16).add("Very Hard", 24);
        DuckHunt.add("Misses per Game", 1).add("3", 0).add("5", 32);
        DuckHunt.add("Bonus Life").add("30000", 0).add("50000", 64).add("80000", 128).add("100000", 192);
        Excitebike.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        Excitebike.add("Bonus").add("100k and Every 50k", 0).add("Every 100k", 16).add("100k Only", 8).add("None", 24);
        Excitebike.add("1st Half Qualifying Time").add("Normal", 0).add("Hard", 32);
        Excitebike.add("2nd Half Qualifying Time").add("Normal", 0).add("Hard", 64);
        ExcitebikeJapan.addAll(Excitebike.getDipSwitches());
        FreedomForce.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("2 Coins / 1 Credit", 6).add("3 Coins / 1 Credit", 1).add("4 Coins / 1 Credit", 5).add("5 Coins / 1 Credit", 3).add("Free Play", 7);
        FreedomForce.add("Unknown/Unused").add("Off", 0).add("On", 8);
        FreedomForce.add("Unknown/Unused").add("Off", 0).add("On", 16);
        FreedomForce.add("Unknown/Unused").add("Off", 0).add("On", 32);
        FreedomForce.add("Unknown/Unused").add("Off", 0).add("On", 64);
        FreedomForce.add("Unknown/Unused").add("Off", 0).add("On", 128);
        LadiesGolf.add("Coinage").add("1 Coin / 1 Credit", 1).add("1 Coin / 2 Credits", 6).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 4).add("2 Coins / 1 Credit", 5).add("3 Coins / 1 Credit", 3).add("4 Coins / 1 Credit", 7).add("Free Play", 0);
        LadiesGolf.add("Hole Size").add("Large", 0).add("Small", 8);
        LadiesGolf.add("Points per Stroke").add("Easier", 0).add("Harder", 16);
        LadiesGolf.add("Starting Points").add("10", 0).add("13", 64).add("16", 32).add("20", 96);
        LadiesGolf.add("Difficulty Vs. Computer").add("Easy", 0).add("Hard", 128);
        Goonies.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("2 Coins / 1 Credit", 6).add("3 Coins / 1 Credit", 1).add("4 Coins / 1 Credit", 5).add("5 Coins / 1 Credit", 3).add("Free Play", 7);
        Goonies.add("Lives").add("3", 0).add("2", 8);
        Goonies.add("Unknown/Unused").add("Off", 0).add("On", 16);
        Goonies.add("Unknown/Unused").add("Off", 0).add("On", 32);
        Goonies.add("Timer").add("Normal", 0).add("Fast", 64);
        Goonies.add("Demo Sounds", 1).add("Off", 0).add("On", 128);
        Gradius.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("2 Coins / 1 Credit", 6).add("3 Coins / 1 Credit", 1).add("4 Coins / 1 Credit", 5).add("5 Coins / 1 Credit", 3).add("Free Play", 7);
        Gradius.add("Lives").add("3", 8).add("4", 0);
        Gradius.add("Bonus").add("100k", 0).add("200k", 32).add("300k", 16).add("400k", 48);
        Gradius.add("Difficulty").add("Normal", 0).add("Hard", 64);
        Gradius.add("Demo Sounds", 1).add("Off", 0).add("On", 128);
        Gumshoe.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("2 Coins / 1 Credit", 6).add("3 Coins / 1 Credit", 1).add("4 Coins / 1 Credit", 5).add("5 Coins / 1 Credit", 3).add("Free Play", 7);
        Gumshoe.add("Difficulty", 1).add("Easy", 0).add("Normal", 8).add("Hard", 16).add("Very Hard", 24);
        Gumshoe.add("Lives", 1).add("3", 16).add("5", 0);
        Gumshoe.add("Bullets per Balloon", 1).add("2", 64).add("3", 0);
        Gumshoe.add("Bonus Life").add("80000", 0).add("100000", 128);
        HogansAlley.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("2 Coins / 1 Credit", 6).add("3 Coins / 1 Credit", 1).add("4 Coins / 1 Credit", 5).add("5 Coins / 1 Credit", 3).add("Free Play", 7);
        HogansAlley.add("Difficulty", 1).add("Easy", 0).add("Normal", 8).add("Hard", 16).add("Very Hard", 24);
        HogansAlley.add("Misses per Game", 1).add("3", 0).add("5", 32);
        HogansAlley.add("Bonus Life").add("30000", 0).add("50000", 64).add("80000", 128).add("100000", 192);
        IceClimber.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        IceClimber.add("Lives").add("3", 0).add("4", 16).add("5", 8).add("7", 24);
        IceClimber.add("Difficulty").add("Normal", 0).add("Hard", 32);
        IceClimber.add("Time before the bear").add("Long", 0).add("Short", 64);
        IceClimber_2.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        IceClimber_2.add("Lives").add("3", 0).add("4", 16).add("5", 8).add("7", 24);
        IceClimber_2.add("Difficulty").add("Normal", 0).add("Hard", 32);
        IceClimber_2.add("Time before the bear").add("Long", 0).add("Short", 64);
        IceClimberDual.add("Coinage (Left Side)").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        IceClimberDual.add("Lives (Left Side)").add("3", 0).add("4", 16).add("5", 8).add("7", 24);
        IceClimberDual.add("Unknown/Unused").add("Off", 0).add("On", 32);
        IceClimberDual.add("Unknown/Unused").add("Off", 0).add("On", 64);
        IceClimberDual.add("Mode (Left Side)").add("Game", 0).add("Test", 128);
        IceClimberDual.add("Coinage (Right Side)").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 1024).add("1 Coin / 3 Credits", 512).add("1 Coin / 4 Credits", 1536).add("2 Coins / 1 Credit", 256).add("3 Coins / 1 Credit", 1280).add("4 Coins / 1 Credit", 768).add("Free Play", 1792);
        IceClimberDual.add("Lives (Right Side)").add("3", 0).add("4", 4096).add("5", 2048).add("7", 6144);
        IceClimberDual.add("Unknown/Unused").add("Off", 0).add("On", 8192);
        IceClimberDual.add("Unknown/Unused").add("Off", 0).add("On", 16384);
        IceClimberDual.add("Mode (Right Side)").add("Game", 0).add("Test", 32768);
        MachRider.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        MachRider.add("Time").add("280", 0).add("250", 16).add("220", 8).add("200", 24);
        MachRider.add("Unknown/Unused").add("Off", 0).add("On", 32);
        MachRider.add("Unknown/Unused").add("Off", 0).add("On", 64);
        MachRider.add("Unknown/Unused").add("Off", 0).add("On", 128);
        MachRider_2.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        MachRider_2.add("Time").add("280", 0).add("250", 16).add("220", 8).add("200", 24);
        MachRider_2.add("Unknown/Unused").add("Off", 0).add("On", 32);
        MachRider_2.add("Unknown/Unused").add("Off", 0).add("On", 64);
        MachRider_2.add("Unknown/Unused").add("Off", 0).add("On", 128);
        MachRiderJapan.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        MachRiderJapan.add("Km 1st Race").add("12", 0).add("15", 16);
        MachRiderJapan.add("Unknown/Unused").add("Off", 0).add("On", 32);
        MachRiderJapan.add("Unknown/Unused").add("Off", 0).add("On", 64);
        MachRiderJapan.add("Unknown/Unused").add("Off", 0).add("On", 128);
        Mahjong.add("Unknown/Unused").add("Off", 0).add("On", 1);
        Mahjong.add("Unknown/Unused").add("Off", 0).add("On", 2);
        Mahjong.add("Unknown/Unused").add("Off", 0).add("On", 4);
        Mahjong.add("Unknown/Unused").add("Off", 0).add("On", 8);
        Mahjong.add("Time", 3).add("30", 48).add("45", 16).add("60", 32).add("90", 0);
        Mahjong.add("Unknown/Unused").add("Off", 0).add("On", 64);
        Mahjong.add("Unknown/Unused").add("Off", 0).add("On", 128);
        Mahjong.add("Mode").add("Game", 0).add("Test", 256);
        Mahjong.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 1024).add("2 Coins / 1 Credit", 512).add("Free Play", 1536);
        Mahjong.add("Unknown/Unused").add("Off", 0).add("On", 2048);
        Mahjong.add("Unknown/Unused").add("Off", 0).add("On", 4096);
        Mahjong.add("Starting Points", 1).add("15k", 24576).add("20k", 8192).add("25k", 16384).add("30k", 0);
        Mahjong.add("Demo Sounds", 1).add("Off", 0).add("On", 32768);
        MightyBombJack.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("5 Coins / 1 Credit", 7);
        MightyBombJack.add("Lives").add("2", 16).add("3", 0).add("4", 8).add("5", 24);
        MightyBombJack.add("Unknown/Unused").add("Off", 0).add("On", 32);
        MightyBombJack.add("Unknown/Unused").add("Off", 0).add("On", 64);
        MightyBombJack.add("Unknown/Unused").add("Off", 0).add("On", 128);
        NinjaJajamaruKun.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        NinjaJajamaruKun.add("Lives").add("3", 0).add("4", 16).add("5", 8);
        NinjaJajamaruKun.add("Unknown/Unused").add("Off", 0).add("On", 32);
        NinjaJajamaruKun.add("Unknown/Unused").add("Off", 0).add("On", 64);
        NinjaJajamaruKun.add("Demo Sounds", 1).add("Off", 0).add("On", 128);
        Pinball.add("Coinage").add("1 Coin / 1 Credit", 1).add("1 Coin / 2 Credits", 6).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 4).add("2 Coins / 1 Credit", 5).add("3 Coins / 1 Credit", 3).add("4 Coins / 1 Credit", 7).add("Free Play", 0);
        Pinball.add("Unknown/Unused").add("Off", 0).add("On", 8);
        Pinball.add("Unknown/Unused").add("Off", 0).add("On", 16);
        Pinball.add("Balls", 1).add("2", 96).add("3", 0).add("4", 64).add("5", 32);
        Pinball.add("Ball Speed").add("Normal", 0).add("Fast", 128);
        PinballJapan.addAll(Pinball.getDipSwitches());
        Platoon.add("Unknown/Unused").add("Off", 0).add("On", 1);
        Platoon.add("Unknown/Unused").add("Off", 0).add("On", 2);
        Platoon.add("Demo Sounds", 1).add("Off", 0).add("On", 4);
        Platoon.add("Unknown/Unused").add("Off", 0).add("On", 8);
        Platoon.add("Unknown/Unused").add("Off", 0).add("On", 16);
        Platoon.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 32).add("1 Coin / 3 Credits", 64).add("2 Coins / 1 Credit", 96).add("3 Coins / 1 Credit", 128).add("4 Coins / 1 Credit", 160).add("5 Coins / 1 Credit", 192).add("Free Play", 224);
        RaidOnBungelingBay.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("4 Coins / 1 Credit", 3).add("3 Coins / 1 Credit", 5).add("Free Play", 7);
        RaidOnBungelingBay.add("Lives").add("2", 0).add("3", 8);
        RaidOnBungelingBay.add("Unknown/Unused").add("Off", 0).add("On", 16);
        RaidOnBungelingBay.add("Unknown/Unused").add("Off", 0).add("On", 32);
        RaidOnBungelingBay.add("Unknown/Unused").add("Off", 0).add("On", 64);
        RaidOnBungelingBay.add("Unknown/Unused").add("Off", 0).add("On", 128);
        RbiBaseball.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 1).add("2 Coins / 1 Credit", 2).add("3 Coins / 1 Credit", 3);
        RbiBaseball.add("Max. 1p/in, 2p/in, Min", 1).add("2, 1, 3", 4).add("2, 2, 4", 12).add("3, 2, 6", 0).add("4, 3, 7", 8);
        RbiBaseball.add("Demo Sounds", 1).add("Off", 0).add("On", 16);
        RbiBaseball.add("PPU", 2).add("RP2C03", 32).add("RP2C04-0001", 0).add("RP2C04-0002", 64).add("RP2C04-0003", 128).add("RP2C04-0004", 192);
        RbiBaseball_2.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 1).add("2 Coins / 1 Credit", 2).add("3 Coins / 1 Credit", 3);
        RbiBaseball_2.add("Max. 1p/in, 2p/in, Min", 1).add("2, 1, 3", 4).add("2, 2, 4", 12).add("3, 2, 6", 0).add("4, 3, 7", 8);
        RbiBaseball_2.add("Demo Sounds", 1).add("Off", 0).add("On", 16);
        RbiBaseball_2.add("PPU", 1).add("RP2C03", 32).add("RP2C04-0001", 0).add("RP2C04-0002", 64).add("RP2C04-0003", 128).add("RP2C04-0004", 192);
        SkateKids.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 6).add("1 Coin / 3 Credits", 1).add("1 Coin / 4 Credits", 5).add("1 Coin / 5 Credits", 3).add("2 Coins / 1 Credit", 4).add("3 Coins / 1 Credit", 2).add("Free Play", 7);
        SkateKids.add("Lives", 1).add("2", 8).add("3", 0);
        SkateKids.add("Bonus Life").add("100", 0).add("150", 32).add("200", 16).add("250", 48);
        SkateKids.add("Timer").add("Normal", 0).add("Fast", 64);
        SkateKids.add("Continue Lives").add("3", 128).add("4", 0);
        Slalom.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("2 Coins / 1 Credit", 6).add("3 Coins / 1 Credit", 1).add("4 Coins / 1 Credit", 5).add("5 Coins / 1 Credit", 3).add("Free Play", 7);
        Slalom.add("Freestyle Points").add("Left / Right", 0).add("Hold Time", 8);
        Slalom.add("Difficulty", 1).add("Easy", 0).add("Normal", 16).add("Hard", 32).add("Hardest", 48);
        Slalom.add("Allow Continue", 1).add("No", 64).add("Yes", 0);
        Slalom.add("Inverted input").add("Off", 0).add("On", 128);
        Soccer.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        Soccer.add("Points Timer", 2).add("600 Pts", 0).add("800 Pts", 16).add("1000 Pts", 8).add("1200 Pts", 24);
        Soccer.add("Difficulty", 1).add("Easy", 0).add("Normal", 64).add("Hard", 32).add("Very Hard", 96);
        Soccer_2.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("1 Coin / 4 Credits", 6).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 5).add("4 Coins / 1 Credit", 3).add("Free Play", 7);
        Soccer_2.add("Points Timer", 2).add("600 Pts", 0).add("800 Pts", 16).add("1000 Pts", 8).add("1200 Pts", 24);
        Soccer_2.add("Difficulty", 1).add("Easy", 0).add("Normal", 64).add("Hard", 32).add("Very Hard", 96);
        StarLuster.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 2).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 3);
        StarLuster.add("Unknown/Unused").add("Off", 0).add("On", 4);
        StarLuster.add("Unknown/Unused").add("Off", 0).add("On", 8);
        StarLuster.add("Unknown/Unused").add("Off", 0).add("On", 16);
        StarLuster.add("Palette Color").add("Black", 64).add("Green", 32).add("Grey", 96);
        StarLuster.add("Unknown/Unused").add("Off", 0).add("On", 128);
        StrokeAndMatchGolf.addAll(LadiesGolf.getDipSwitches());
        StrokeAndMatchGolfJapan.addAll(LadiesGolf.getDipSwitches());
        SuperMarioBros.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 6).add("1 Coin / 3 Credits", 1).add("1 Coin / 4 Credits", 5).add("1 Coin / 5 Credits", 3).add("2 Coins / 1 Credit", 4).add("3 Coins / 1 Credit", 2).add("Free Play", 7);
        SuperMarioBros.add("Lives", 1).add("2", 8).add("3", 0);
        SuperMarioBros.add("Bonus Life").add("100", 0).add("150", 32).add("200", 16).add("250", 48);
        SuperMarioBros.add("Timer").add("Normal", 0).add("Fast", 64);
        SuperMarioBros.add("Continue Lives").add("3", 128).add("4", 0);
        SuperSkyKid.add("Unknown/Unused").add("Off", 0).add("On", 1);
        SuperSkyKid.add("Unknown/Unused").add("Off", 0).add("On", 2);
        SuperSkyKid.add("Lives").add("2", 0).add("3", 4);
        SuperSkyKid.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 8).add("2 Coins / 1 Credit", 16).add("3 Coins / 1 Credit", 24);
        SuperSkyKid.add("PPU", 2).add("RP2C03", 32).add("RP2C04-0001", 0).add("RP2C04-0002", 64).add("RP2C04-0003", 128).add("RP2C04-0004", 192);
        SuperXevious.add("Unknown/Unused").add("Off", 0).add("On", 1);
        SuperXevious.add("Unknown/Unused").add("Off", 0).add("On", 2);
        SuperXevious.add("Unknown/Unused").add("Off", 0).add("On", 4);
        SuperXevious.add("Unknown/Unused").add("Off", 0).add("On", 8);
        SuperXevious.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 16).add("2 Coins / 1 Credit", 32).add("3 Coins / 1 Credit", 48);
        SuperXevious.add("PPU", 1).add("RP2C04-0001", 0).add("RP2C04-0002", 64).add("RP2C04-0003", 128).add("RP2C04-0004", 192);
        Tennis.add("Difficulty vs. Computer").add("Easy", 0).add("Normal", 2).add("Medium", 1).add("Hard", 3);
        Tennis.add("Difficulty vs. Player").add("Easy", 0).add("Normal", 8).add("Medium", 4).add("Hard", 12);
        Tennis.add("Raquet Size").add("Large", 0).add("Small", 16);
        Tennis.add("Extra Score").add("1 Set", 0).add("1 Game", 32);
        Tennis.add("Court Color").add("Green", 0).add("Blue", 64);
        Tennis.add("Copyright").add("Japan", 0).add("USA", 128);
        Tennis.add("Mode").add("Game", 0).add("Test", 256);
        Tennis.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 1024).add("2 Coins / 1 Credit", 512).add("Free Play", 1536);
        Tennis.add("Game Mode - Credits (1VsC/2VsC/1Vs1/2Vs2)", 2).add("A - 1/1/1/1", 0).add("B - 1/2/1/2", 4096).add("C - 2/2/2/2", 2048).add("D - 2/2/4/4", 6144);
        Tennis.add("Rackets Per Game", 1).add("2", 24576).add("3", 0).add("4", 16384).add("5", 8192);
        Tennis.add("Demo Sounds", 1).add("Off", 0).add("On", 32768);
        Tetris.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 2).add("2 Coins / 1 Credit", 1).add("3 Coins / 1 Credit", 3);
        Tetris.add("Unknown/Unused").add("Off", 0).add("On", 4);
        Tetris.add("Unknown/Unused").add("Off", 0).add("On", 8);
        Tetris.add("Unknown/Unused").add("Off", 0).add("On", 16);
        Tetris.add("Palette Color").add("Black", 64).add("Green", 32).add("Grey", 96);
        Tetris.add("Unknown/Unused").add("Off", 0).add("On", 128);
        TkoBoxing.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 1).add("2 Coins / 1 Credit", 2).add("3 Coins / 1 Credit", 3);
        TkoBoxing.add("Unknown/Unused").add("Off", 0).add("On", 4);
        TkoBoxing.add("Unknown/Unused").add("Off", 0).add("On", 8);
        TkoBoxing.add("Unknown/Unused").add("Off", 0).add("On", 16);
        TkoBoxing.add("Palette Color", 1).add("Black", 0).add("White", 32);
        TkoBoxing.add("Unknown/Unused").add("Off", 0).add("On", 64);
        TkoBoxing.add("Unknown/Unused").add("Off", 0).add("On", 128);
        TopGun.add("Coinage").add("1 Coin / 1 Credit", 0).add("1 Coin / 2 Credits", 4).add("1 Coin / 3 Credits", 2).add("2 Coins / 1 Credit", 6).add("3 Coins / 1 Credit", 1).add("4 Coins / 1 Credit", 5).add("5 Coins / 1 Credit", 3).add("Free Play", 7);
        TopGun.add("Lives per Coin").add("3 - 12 Max", 0).add("2 - 9 Max", 8);
        TopGun.add("Bonus").add("30k and every 50k", 0).add("50k and every 100k", 32).add("100k and every 150k", 16).add("200k and every 200k", 48);
        TopGun.add("Difficulty").add("Normal", 0).add("Hard", 64);
        TopGun.add("Demo Sounds", 1).add("Off", 0).add("On", 128);
        WreckingCrew.add("Lives").add("3", 0).add("4", 2).add("5", 1).add("6", 3);
        WreckingCrew.add("1st Bonus Life", 3).add("20k", 0).add("30k", 16).add("40k", 8).add("50k", 24).add("70k", 4).add("80k", 20).add("100k", 12).add("None", 28);
        WreckingCrew.add("Additional Bonus Lives", 7).add("20k", 0).add("30k", 128).add("40k", 64).add("50k", 192).add("70k", 32).add("80k", 96).add("100k", 160).add("None", 224);
        WreckingCrew.add("Coinage").add("1 Coin / 1 Credit", 256).add("1 Coin / 2 Credits", 1536).add("1 Coin / 3 Credits", 512).add("1 Coin / 4 Credits", 1024).add("2 Coins / 1 Credit", 1280).add("3 Coins / 1 Credit", 768).add("4 Coins / 1 Credit", 1792).add("Free Play", 0);
        WreckingCrew.add("Difficulty", 1).add("Easy", 0).add("Normal", 2048).add("Medium", 4096).add("Hard", 6144);
        WreckingCrew.add("Copyright").add("Japan", 0).add("USA", 8192);
        WreckingCrew.add("Unused").add("Off", 0).add("On", 16384);
        WreckingCrew.add("Unused").add("Off", 0).add("On", 32768);
        NameMappings = new Object[][]{{"rbi", RbiBaseball}, {"r.b.i.", RbiBaseball}, {"balloon", BalloonFight}, {"baseball", Baseball}, {"battle", BattleCity}, {"land", CluCluLand}, {"dr", DrMario}, {"duck", DuckHunt}, {"eb4-4", ExcitebikeJapan}, {"excite", Excitebike}, {"force", FreedomForce}, {"goonies", Goonies}, {"gradius", Gradius}, {"gumshoe", Gumshoe}, {"alley", HogansAlley}, {"ic4-4", IceClimber_2}, {"climber dual", IceClimberDual}, {"climber", IceClimber}, {"mr4-1", MachRiderJapan}, {"rider", MachRider}, {"ladies", LadiesGolf}, {"mahjong", Mahjong}, {"mighty", MightyBombJack}, {"ninja", NinjaJajamaruKun}, {"pinball", Pinball}, {"platoon", Platoon}, {"skate", SkateKids}, {"sc4-2", Soccer_2}, {"soccer", Soccer}, {"luster", StarLuster}, {"stroke", StrokeAndMatchGolf}, {"kid", SuperSkyKid}, {"xevious", SuperXevious}, {"tennis", Tennis}, {"tetris", Tetris}, {"top", TopGun}, {"castle", Castlevania}, {"slalom", Slalom}, {"mario", SuperMarioBros}, {"crew", WreckingCrew}, {"tko", TkoBoxing}, {"t.k.o.", TkoBoxing}, {"raid", RaidOnBungelingBay}};
    }
}

