/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.ntdec;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class NTD03
extends Mapper {
    private static final long serialVersionUID = 0L;

    public NTD03(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.writeRegister(32768, 0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public void writeRegister(int address, int value) {
        int bank = address >> 10 & 0x1E;
        if (BitUtil.getBitBool(address, 7)) {
            this.setPrgBank(2, bank | address >> 6 & 1);
            this.setPrgBank(3, bank | address >> 6 & 1);
        } else {
            this.setPrgBanks(2, 2, bank & 0xFE);
        }
        this.setChrBank((address & 0x300) >> 5 | address & 7);
        this.setNametableMirroring(BitUtil.getBit(address, 10));
    }
}

