/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.ntdec;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.tv.TVSystem;
import nintaco.util.StreamUtil;

public class PC95KO01
extends MMC3 {
    private static final double MAX_SAMPLE_COUNT = TVSystem.NTSC.getCyclesPerSecond() / 4000.0;
    private transient int[] queue = new int[4096];
    private int queueSize;
    private int head;
    private int tail;
    private int outer0;
    private int outer1;
    private int keyboardRow;
    private int bits;
    private int shift;
    private int sample;
    private boolean SCL;
    private boolean SDA;
    private boolean state;
    private double sampleCount;

    public PC95KO01(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.outer1 = 224;
        this.outer0 = 224;
        this.bits = 0;
        this.queueSize = 0;
        this.sample = 0;
        this.tail = 0;
        this.head = 0;
        this.sampleCount = 0.0;
        this.state = false;
        this.SCL = false;
        this.SDA = false;
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void updatePrgBanks() {
        if (this.prgMode) {
            this.setPrgBank(4, this.outer0 | 0x1E);
            this.setPrgBank(5, this.outer1 | this.R[7] & 0x1F);
            this.setPrgBank(6, 0xE0 | this.R[6] & 0x1F);
            this.setPrgBank(7, -1);
        } else {
            this.setPrgBank(4, this.outer0 | this.R[6] & 0x1F);
            this.setPrgBank(5, this.outer1 | this.R[7] & 0x1F);
            this.setPrgBank(6, -2);
            this.setPrgBank(7, -1);
        }
    }

    private void enqueue(int value) {
        if (this.queueSize < 4096) {
            ++this.queueSize;
            this.queue[this.head] = value;
            ++this.head;
            this.head &= 0xFFF;
        }
    }

    private int readKeyboardButtonState() {
        int state = 0;
        this.writeOutputPort(5);
        for (int i = 0; i <= this.keyboardRow; ++i) {
            this.writeOutputPort(4);
            state = this.readInputPort(1) >> 1 & 0xF;
            this.writeOutputPort(6);
            state |= this.readInputPort(1) << 3 & 0xF0;
        }
        return state;
    }

    @Override
    public int readMemory(int address) {
        switch (address) {
            case 18694: {
                return this.readKeyboardButtonState();
            }
            case 19459: {
                return 0;
            }
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        switch (address) {
            case 18692: {
                this.keyboardRow = value;
                break;
            }
            case 19456: {
                this.outer0 = value & 0xE0;
                this.updatePrgBanks();
                break;
            }
            case 19457: {
                this.outer1 = value & 0xE0;
                this.updatePrgBanks();
                break;
            }
            case 19460: {
                this.SCL = false;
                break;
            }
            case 19461: {
                if (!this.SCL && this.state) {
                    this.shift = this.bits < 0 ? 0 : this.shift << 1 | (this.SDA ? 1 : 0);
                    ++this.bits;
                }
                this.SCL = true;
                break;
            }
            case 19462: {
                if (this.SCL && this.SDA && !this.state) {
                    this.bits = -1;
                    this.shift = 0;
                    this.state = true;
                }
                this.SDA = false;
                break;
            }
            case 19463: {
                int i;
                int command = 0;
                int param = 0;
                int paramBits = 0;
                if (!this.SCL || this.SDA || !this.state) break;
                for (i = 0; i < 4; ++i) {
                    command = command << 1 | this.shift & 1;
                    this.shift >>= 1;
                    --this.bits;
                }
                paramBits = this.bits;
                for (i = 0; i < paramBits; ++i) {
                    param = param << 1 | this.shift & 1;
                    this.shift >>= 1;
                    --this.bits;
                }
                this.enqueue(param & 0xF);
                this.enqueue(param >> 4 & 0xF);
                this.enqueue(param >> 8 & 0xF);
                this.state = false;
                break;
            }
            default: {
                super.writeMemory(address, value);
            }
        }
    }

    @Override
    public void writeTransients(DataOutput out) throws IOException {
        super.writeTransients(out);
        StreamUtil.writeByteArray(out, this.queue);
    }

    @Override
    public void readTransients(DataInput in) throws IOException {
        super.readTransients(in);
        this.queue = StreamUtil.readByteArray(in);
    }

    @Override
    public float getAudioSample() {
        double d;
        this.sampleCount += 1.0;
        if (d >= MAX_SAMPLE_COUNT) {
            this.sampleCount -= MAX_SAMPLE_COUNT;
            if (this.queueSize > 0) {
                --this.queueSize;
                this.sample = this.queue[this.tail] << 8;
                System.out.println(this.sample);
                ++this.tail;
                this.tail &= 0xFFF;
            } else {
                this.sample = 0;
            }
        }
        return this.sample;
    }

    @Override
    public int getAudioMixerScale() {
        return Short.MAX_VALUE;
    }
}

