/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMC60311C
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int innerBank;
    private int outerBank;
    private int mode;

    public BMC60311C(CartFile cartFile) {
        super(cartFile, 4, 1, 24576, 32768);
    }

    @Override
    public void init() {
        this.mode = 0;
        this.outerBank = 0;
        this.innerBank = 0;
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        int value = this.outerBank | (BitUtil.getBitBool(this.mode, 2) ? 0 : this.innerBank);
        switch (this.mode & 3) {
            case 0: {
                this.setPrgBank(2, value);
                this.setPrgBank(3, value);
                break;
            }
            case 1: {
                this.set2PrgBanks(2, value & 0xFE);
                break;
            }
            case 2: {
                this.setPrgBank(2, value);
                this.setPrgBank(3, this.outerBank | 7);
            }
        }
        this.setNametableMirroring(BitUtil.getBit(this.mode, 3));
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address >= 32768) {
            this.innerBank = value & 7;
        } else if ((address & 1) == 0) {
            this.mode = value;
        } else {
            this.outerBank = value;
        }
        this.updateState();
    }
}

