/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper035
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int irqCounter;
    private boolean irqEnabled;
    private boolean lastA12;

    public Mapper035(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.irqCounter = 0;
        this.irqEnabled = false;
        this.setPrgBank(3, -1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF007) {
            case 32768: 
            case 32769: 
            case 32770: 
            case 32771: {
                this.setPrgBank(4 | address & 3, value);
                break;
            }
            case 36864: 
            case 36865: 
            case 36866: 
            case 36867: 
            case 36868: 
            case 36869: 
            case 36870: 
            case 36871: {
                this.setChrBank(address & 7, value);
                break;
            }
            case 49154: {
                this.irqEnabled = false;
                this.cpu.setMapperIrq(false);
                break;
            }
            case 49155: {
                this.irqEnabled = true;
                break;
            }
            case 49157: {
                this.irqCounter = value;
                break;
            }
            case 53249: {
                this.setNametableMirroring(value & 1);
            }
        }
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        boolean a12;
        boolean bl = a12 = (address & 0x1000) != 0;
        if (this.irqEnabled && !this.lastA12 && a12) {
            this.irqCounter = this.irqCounter - 1 & 0xFF;
            if (this.irqCounter == 0) {
                this.irqEnabled = false;
                this.cpu.setMapperIrq(true);
            }
        }
        this.lastA12 = a12;
    }
}

