/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper060
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean cartMode;
    private boolean bmcVT5201;
    private int game;

    public Mapper060(CartFile cartFile) {
        super(cartFile, 4, 1);
        this.bmcVT5201 = this.prgRomLength != 65536 || this.chrRomLength != 32768;
    }

    @Override
    public void init() {
        if (this.bmcVT5201) {
            this.setPrgBank(2, 0);
            this.setPrgBank(3, 1);
            this.setChrBank(0, 0);
            this.writeRegister(32768, 0);
        } else {
            this.setPrgBank(2, this.game);
            this.setPrgBank(3, this.game);
            this.setChrBank(0, this.game);
        }
    }

    @Override
    public void resetting() {
        this.game = this.game + 1 & 3;
        this.init();
    }

    @Override
    public int readMemory(int address) {
        if (this.bmcVT5201 && this.cartMode && address >= 32768) {
            return this.game;
        }
        return super.readMemory(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (this.bmcVT5201) {
            this.cartMode = BitUtil.getBitBool(address, 8);
            this.setNametableMirroring((address & 8) >> 3);
            this.setPrgBank(2, address >> 4 & ~(~address >> 7 & 1));
            this.setPrgBank(3, address >> 4 | ~address >> 7 & 1);
            this.setChrBank(address);
        }
    }
}

