/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper106
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int irqCounter;
    private boolean irqEnabled;

    public Mapper106(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.setPrgBank(4, -1);
        this.setPrgBank(5, -1);
        this.setPrgBank(6, -1);
        this.setPrgBank(7, -1);
    }

    @Override
    public void update() {
        if (this.irqEnabled) {
            this.irqCounter = this.irqCounter + 1 & 0xFFFF;
            if (this.irqCounter == 0) {
                this.cpu.setMapperIrq(true);
                this.irqEnabled = false;
            }
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF) {
            case 0: 
            case 2: {
                this.setChrBank(address & 7, value & 0xFE);
                break;
            }
            case 1: 
            case 3: {
                this.setChrBank(address & 7, value | 1);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.setChrBank(address & 7, value);
                break;
            }
            case 8: {
                this.setPrgBank(4, value & 0xF | 0x10);
                break;
            }
            case 9: {
                this.setPrgBank(5, value & 0x1F);
                break;
            }
            case 10: {
                this.setPrgBank(6, value & 0x1F);
                break;
            }
            case 11: {
                this.setPrgBank(7, value & 0xF | 0x10);
                break;
            }
            case 13: {
                this.irqEnabled = false;
                this.irqCounter = 0;
                this.cpu.setMapperIrq(false);
                break;
            }
            case 14: {
                this.irqCounter = this.irqCounter & 0xFF00 | value;
                break;
            }
            case 15: {
                this.irqCounter = this.irqCounter & 0xFF | value << 8;
                this.irqEnabled = true;
            }
        }
    }
}

