/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper227
extends Mapper {
    private static final long serialVersionUID = 0L;

    public Mapper227(CartFile cartFile) {
        super(cartFile, 4, 0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void writeRegister(int address, int value) {
        int bank = (address & 0x100) >> 3 | (address & 0x7C) >> 2;
        int OSL = (address & 0x80) >> 5 | (address & 1) << 1 | (address & 0x200) >> 9;
        this.setNametableMirroring(BitUtil.getBit(address, 1));
        switch (OSL) {
            case 0: {
                this.setPrgBank(2, bank);
                this.setPrgBank(3, bank & 0x38);
                break;
            }
            case 1: {
                this.setPrgBank(2, bank);
                this.setPrgBank(3, bank | 7);
                break;
            }
            case 2: {
                this.setPrgBank(2, bank & 0x3E);
                this.setPrgBank(3, bank & 0x38);
                break;
            }
            case 3: {
                this.setPrgBank(2, bank & 0x3E);
                this.setPrgBank(3, bank | 7);
                break;
            }
            case 4: 
            case 5: {
                this.setPrgBank(2, bank);
                this.setPrgBank(3, bank);
                break;
            }
            case 6: 
            case 7: {
                this.setPrgBanks(2, 2, bank & 0xFE);
            }
        }
    }
}

