/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper272
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] prgRegs = new int[2];
    private final int[] chrRegs = new int[8];
    private int hvMirroring;
    private int oneScreenMirroring;
    private int lastBit13;
    private int irqCounter;
    private boolean irqCounterEnabled;

    public Mapper272(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.irqCounter = 0;
        this.lastBit13 = 0;
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        this.setPrgBank(4, this.prgRegs[0]);
        this.setPrgBank(5, this.prgRegs[1]);
        this.setPrgBank(6, -2);
        this.setPrgBank(7, -1);
        for (int i = 7; i >= 0; --i) {
            this.setChrBank(i, this.chrRegs[i]);
        }
        switch (this.oneScreenMirroring) {
            case 2: 
            case 3: {
                this.setNametableMirroring(this.oneScreenMirroring);
                break;
            }
            default: {
                this.setNametableMirroring(this.hvMirroring);
            }
        }
    }

    @Override
    public int readVRAM(int address) {
        int bit13 = address >> 13 & 1;
        if (this.lastBit13 == 1 && bit13 == 0 && this.irqCounterEnabled && ++this.irqCounter == 84) {
            this.irqCounter = 0;
            this.cpu.setMapperIrq(true);
        }
        this.lastBit13 = bit13;
        return super.readVRAM(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (0xF003 & address) {
            case 32768: 
            case 32769: 
            case 32770: 
            case 32771: {
                this.prgRegs[0] = value;
                break;
            }
            case 40960: 
            case 40961: 
            case 40962: 
            case 40963: {
                this.prgRegs[1] = value;
                break;
            }
            case 36864: 
            case 36865: 
            case 36866: 
            case 36867: {
                this.hvMirroring = value & 1;
                break;
            }
            case 45056: {
                this.chrRegs[0] = this.chrRegs[0] & 0xF0 | value & 0xF;
                break;
            }
            case 45057: {
                this.chrRegs[0] = (value & 0xF) << 4 | this.chrRegs[0] & 0xF;
                break;
            }
            case 45058: {
                this.chrRegs[1] = this.chrRegs[1] & 0xF0 | value & 0xF;
                break;
            }
            case 45059: {
                this.chrRegs[1] = (value & 0xF) << 4 | this.chrRegs[1] & 0xF;
                break;
            }
            case 49152: {
                this.chrRegs[2] = this.chrRegs[2] & 0xF0 | value & 0xF;
                break;
            }
            case 49153: {
                this.chrRegs[2] = (value & 0xF) << 4 | this.chrRegs[2] & 0xF;
                break;
            }
            case 49154: {
                this.chrRegs[3] = this.chrRegs[3] & 0xF0 | value & 0xF;
                break;
            }
            case 49155: {
                this.chrRegs[3] = (value & 0xF) << 4 | this.chrRegs[3] & 0xF;
                break;
            }
            case 53248: {
                this.chrRegs[4] = this.chrRegs[4] & 0xF0 | value & 0xF;
                break;
            }
            case 53249: {
                this.chrRegs[4] = (value & 0xF) << 4 | this.chrRegs[4] & 0xF;
                break;
            }
            case 53250: {
                this.chrRegs[5] = this.chrRegs[5] & 0xF0 | value & 0xF;
                break;
            }
            case 53251: {
                this.chrRegs[5] = (value & 0xF) << 4 | this.chrRegs[5] & 0xF;
                break;
            }
            case 57344: {
                this.chrRegs[6] = this.chrRegs[6] & 0xF0 | value & 0xF;
                break;
            }
            case 57345: {
                this.chrRegs[6] = (value & 0xF) << 4 | this.chrRegs[6] & 0xF;
                break;
            }
            case 57346: {
                this.chrRegs[7] = this.chrRegs[7] & 0xF0 | value & 0xF;
                break;
            }
            case 57347: {
                this.chrRegs[7] = (value & 0xF) << 4 | this.chrRegs[7] & 0xF;
            }
        }
        switch (0xC00C & address) {
            case 32772: {
                this.oneScreenMirroring = value & 3;
                break;
            }
            case 32780: {
                this.cpu.setMapperIrq(true);
                break;
            }
            case 49156: {
                this.cpu.setMapperIrq(false);
                break;
            }
            case 49160: {
                this.irqCounterEnabled = true;
                break;
            }
            case 49164: {
                this.irqCounterEnabled = false;
                this.irqCounter = 0;
                this.cpu.setMapperIrq(false);
            }
        }
        this.updateState();
    }
}

