/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Mapper354
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean chrRamWritesEnabled;

    public Mapper354(CartFile cartFile) {
        super(cartFile, 8, 1, 61440, 24576);
    }

    @Override
    public void init() {
        this.chrRamWritesEnabled = true;
        this.writeRegister(61440, 0);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void writeRegister(int address, int value) {
        int bank = (value & 0x3F) << 1;
        int lowBit = BitUtil.getBit(value, 7);
        switch (address & 7) {
            case 0: 
            case 4: {
                this.set4PrgBanks(4, bank & 0x7C);
                break;
            }
            case 1: {
                this.set2PrgBanks(4, bank);
                this.set2PrgBanks(6, bank | 0xE);
                break;
            }
            case 2: 
            case 6: {
                this.setPrgBank(4, bank | lowBit);
                this.setPrgBank(5, bank | lowBit);
                this.setPrgBank(6, bank | lowBit);
                this.setPrgBank(7, bank | lowBit);
                break;
            }
            case 3: 
            case 7: {
                this.setPrgBank(4, bank);
                this.setPrgBank(5, bank | 1);
                this.setPrgBank(6, bank);
                this.setPrgBank(7, bank | 1);
                break;
            }
            case 5: {
                this.setPrgBank(3, bank | lowBit);
                this.set4PrgBanks(4, bank & 0xF0 | 0xC);
            }
        }
        this.chrRamWritesEnabled = !BitUtil.getBitBool(address, 3);
        this.setNametableMirroring(BitUtil.getBit(value, 6));
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (this.chrRamWritesEnabled || address >= 8192) {
            this.vram[address] = value;
        }
    }
}

