/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.pirate;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Teletubbies
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean locked;
    private int BBB000;

    public Teletubbies(CartFile cartFile) {
        super(cartFile, 4, 0);
    }

    @Override
    protected void writeRegister(int address, int value) {
        int BBBbbb;
        if (this.locked) {
            BBBbbb = this.BBB000 | value & 7;
        } else {
            this.locked = BitUtil.getBitBool(address, 1);
            BBBbbb = (address & 4) << 3 | value & 0x1F;
            this.BBB000 = BBBbbb & 0x38;
        }
        this.setNametableMirroring(BitUtil.getBit(value, 5) ^ 1);
        switch (address >> 6 & 3) {
            case 0: {
                this.setPrgBank(2, BBBbbb);
                this.setPrgBank(3, BBBbbb | 7);
                break;
            }
            case 1: {
                this.setPrgBank(2, BBBbbb & 0x3E);
                this.setPrgBank(3, BBBbbb | 7);
                break;
            }
            case 2: {
                this.setPrgBank(2, BBBbbb);
                this.setPrgBank(3, BBBbbb);
                break;
            }
            case 3: {
                this.setPrgBank(2, BBBbbb & 0x3E);
                this.setPrgBank(3, BBBbbb | 1);
            }
        }
    }
}

