/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class BMC8In1
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int reg;

    public BMC8In1(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    protected void setChrBank(int bank, int value) {
        super.setChrBank(bank, (this.reg & 0xC) << 5 | value & 0x7F);
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        if (BitUtil.getBitBool(this.reg, 4)) {
            super.setPrgBank(bank, (this.reg & 0xC) << 2 | value & 0xF);
        } else {
            value = (this.reg & 0xF) << 2;
            super.setPrgBank(4, value);
            super.setPrgBank(5, value | 1);
            super.setPrgBank(6, value | 2);
            super.setPrgBank(7, value | 3);
        }
    }

    @Override
    public void writeRegister(int address, int value) {
        if (BitUtil.getBitBool(address, 12)) {
            this.reg = value;
            this.updateBanks();
        } else {
            super.writeRegister(address, value);
        }
    }
}

