/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Boogerman
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] SECURITY = new int[]{0, 2, 5, 3, 6, 1, 7, 4};
    private final int[] regs = new int[4];
    private int bankSelect;

    public Boogerman(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.regs[0] = 0;
        this.regs[1] = 255;
        this.regs[2] = 4;
        this.regs[3] = 0;
        super.updateBanks();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        switch (address) {
            case 20480: 
            case 24576: {
                this.writePrg(value);
                break;
            }
            case 20481: 
            case 24577: {
                this.writeChr(value);
                break;
            }
            case 20487: 
            case 24583: {
                this.writeBanks(value);
                break;
            }
            default: {
                if ((address & 0xE001) == 57345) {
                    this.writeIrqEnable(value);
                    break;
                }
                if (address < 32768) break;
                super.writeRegister(address, value);
            }
        }
    }

    @Override
    public void setPrgBank(int bank, int value) {
        if (!BitUtil.getBitBool(this.regs[0], 7)) {
            value = BitUtil.getBitBool(this.regs[1], 3) ? value & 0x1F | 0x20 : value & 0xF | this.regs[1] & 0x10;
        }
        super.setPrgBank(bank, value);
    }

    @Override
    public void setChrBank(int bank, int value) {
        value = BitUtil.getBitBool(this.regs[1], 2) ? (value |= 0x100) : value & 0x7F | this.regs[1] << 3 & 0x80;
        super.setChrBank(bank, value);
    }

    @Override
    public void updatePrgBanks() {
        if (BitUtil.getBitBool(this.regs[0], 7)) {
            int B = (this.regs[0] & 0xF | this.regs[1] & 0x10) << 1;
            this.setPrgBank(4, B);
            this.setPrgBank(5, B | 1);
            this.setPrgBank(6, B);
            this.setPrgBank(7, B | 1);
        } else {
            super.updatePrgBanks();
        }
    }

    protected void writePrg(int value) {
        if (this.regs[0] != value) {
            this.regs[0] = value;
            this.updatePrgBanks();
        }
    }

    protected void writeChr(int value) {
        if (this.regs[1] != value) {
            this.regs[1] = value;
            super.updateChrBanks();
        }
    }

    protected void writeBanks(int value) {
        this.bankSelect = 0;
        this.chrMode = false;
        this.prgMode = false;
        this.register = 0;
        if (this.regs[2] != value) {
            this.regs[2] = value;
            this.updatePrgBanks();
            super.updateChrBanks();
        }
    }

    @Override
    protected void writeBankSelect(int value) {
        this.bankSelect = value;
        if (this.regs[2] == 0) {
            super.writeBankSelect(value);
        }
    }

    @Override
    protected void writeBankData(int value) {
        if (this.regs[2] != 0) {
            if (!(this.regs[3] == 0 || BitUtil.getBitBool(this.regs[0], 7) && (this.bankSelect & 7) >= 6)) {
                this.regs[3] = 0;
                super.writeBankData(value);
            }
        } else {
            super.writeBankData(value);
        }
    }

    @Override
    protected void writeMirroring(int value) {
        if (this.regs[2] != 0) {
            value = value & 0xC0 | SECURITY[value & 7];
            this.regs[3] = 1;
            super.writeBankSelect(value);
        } else {
            super.writeMirroring(value);
        }
    }

    @Override
    protected void writeIrqLatch(int value) {
        if (this.regs[2] != 0) {
            super.writeMirroring(value >> 7 | value);
        } else {
            super.writeIrqLatch(value);
        }
    }

    @Override
    protected void writeIrqReload() {
        if (this.regs[2] != 0) {
            super.writeIrqEnable();
        } else {
            super.writeIrqReload();
        }
    }

    protected void writeIrqEnable(int value) {
        if (this.regs[2] != 0) {
            super.writeIrqLatch(value);
            super.writeIrqReload();
        } else {
            super.writeIrqEnable();
        }
    }
}

