/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;

public class DragonBallZ5
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private final int[] chrBlocks = new int[2];

    public DragonBallZ5(CartFile cartFile) {
        super(cartFile);
        this.mmc3a = true;
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 16416 && address < 24576) {
            this.writeChrBlockSelect(value);
        } else {
            super.writeMemory(address, value);
        }
    }

    protected void writeChrBlockSelect(int value) {
        this.chrBlocks[0] = (value & 1) << 18;
        this.chrBlocks[1] = (value & 0x10) << 14;
        this.updateChrBanks();
    }

    @Override
    protected void updateChrBanks() {
        super.updateChrBanks();
        for (int i = 0; i < 8; ++i) {
            int n = i;
            this.chrBanks[n] = this.chrBanks[n] | this.chrBlocks[i >> 2];
        }
    }
}

