/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class GN45
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private boolean locked;

    public GN45(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.locked = false;
        this.writeOuterBankRegister(0);
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void writeOuterBankRegister(int address) {
        if (!this.locked) {
            this.locked = BitUtil.getBitBool(address, 7);
            this.setPrgBlock(address &= 0x70, 15);
            this.setChrBlock(address << 3, 127);
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xFF00) == 26624) {
            this.writeOuterBankRegister(address);
        }
        super.writeMemory(address, value);
    }
}

