/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper045
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[4];
    private int regIndex;
    private boolean sramRegisterEnabled;

    public Mapper045(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.sramRegisterEnabled = true;
        this.regIndex = 0;
        this.regs[2] = 15;
        this.updateBanks();
    }

    @Override
    public void resetting() {
    }

    @Override
    public void setChrBank(int bank, int value) {
        super.setChrBank(bank, value & 255 >> 15 - (this.regs[2] & 0xF) | this.regs[0] | (this.regs[2] & 0xF0) << 4);
    }

    @Override
    public void setPrgBank(int bank, int value) {
        super.setPrgBank(bank, value & (0x3F ^ this.regs[3] & 0x3F) | this.regs[1]);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address < 32768) {
            if (this.sramRegisterEnabled && address >= 24576) {
                if (BitUtil.getBitBool(this.regs[3], 6)) {
                    this.sramRegisterEnabled = false;
                } else {
                    this.regs[this.regIndex] = value;
                    this.regIndex = this.regIndex + 1 & 3;
                }
                this.updateBanks();
            }
        } else {
            super.writeRegister(address, value);
        }
    }
}

