/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper114
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] security = new int[]{0, 3, 1, 5, 6, 7, 2, 4};
    private final int[] regs = new int[2];
    private boolean bankSelected;

    public Mapper114(CartFile cartFile) {
        super(cartFile);
        this.mmc3a = true;
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        if (BitUtil.getBitBool(this.regs[0], 7)) {
            int b = (this.regs[0] & 0xF) << 1;
            super.setPrgBank(4, b);
            super.setPrgBank(5, b | 1);
            super.setPrgBank(6, b);
            super.setPrgBank(7, b | 1);
        } else {
            super.setPrgBank(bank, value & 0x3F);
        }
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address >= 32768) {
            switch (address & 0xE001) {
                case 32769: {
                    this.writeMirroring(value);
                    break;
                }
                case 40960: {
                    this.writeBankSelect(value & 0xC0 | security[value & 7]);
                    this.bankSelected = true;
                    break;
                }
                case 49152: {
                    if (!this.bankSelected) break;
                    this.writeBankData(value);
                    this.bankSelected = false;
                    break;
                }
                case 40961: {
                    this.irqReloadValue = value;
                    break;
                }
                case 49153: {
                    this.irqReloadRequest = true;
                    break;
                }
                case 57344: {
                    this.cpu.setMapperIrq(false);
                    this.irqEnabled = false;
                    break;
                }
                case 57345: {
                    this.irqEnabled = true;
                }
            }
        } else if (address >= 20480) {
            this.regs[0] = value;
            this.updatePrgBanks();
        }
    }
}

