/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper217
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] LUT = new int[]{0, 6, 3, 7, 5, 2, 4, 1};
    private final int[] regs = new int[4];

    public Mapper217(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.regs[0] = 0;
        this.regs[1] = 255;
        this.regs[2] = 3;
        this.regs[3] = 0;
        this.updateBanks();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void setChrBank(int bank, int value) {
        if (!BitUtil.getBitBool(this.regs[1], 3)) {
            value = this.regs[1] << 3 & 0x80 | value & 0x7F;
        }
        super.setChrBank(bank, this.regs[1] << 8 & 0x300 | value);
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        value = BitUtil.getBitBool(this.regs[1], 3) ? (value &= 0x1F) : value & 0xF | this.regs[1] & 0x10;
        super.setPrgBank(bank, this.regs[1] << 5 & 0x60 | value);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if (address < 32768) {
            switch (address) {
                case 20480: {
                    this.regs[0] = value;
                    if (BitUtil.getBitBool(value, 7)) {
                        value = value & 0xF | this.regs[1] << 4 & 0x30;
                        this.setPrgBank(4, value <<= 1);
                        this.setPrgBank(5, value + 1);
                        this.setPrgBank(6, value);
                        this.setPrgBank(7, value + 1);
                        break;
                    }
                    this.updatePrgBanks();
                    break;
                }
                case 20481: {
                    if (this.regs[1] == value) break;
                    this.regs[1] = value;
                    this.updatePrgBanks();
                    break;
                }
                case 20487: {
                    this.regs[2] = value;
                }
            }
        } else {
            switch (address & 0xE001) {
                case 32768: {
                    if (this.regs[2] != 0) {
                        this.writeIrqLatch(value);
                        break;
                    }
                    this.writeBankSelect(value);
                    break;
                }
                case 32769: {
                    if (this.regs[2] != 0) {
                        this.regs[3] = 1;
                        this.writeBankSelect(value & 0xC0 | LUT[value & 7]);
                        break;
                    }
                    this.writeBankData(value);
                    break;
                }
                case 40960: {
                    if (this.regs[2] != 0) {
                        if (this.regs[3] == 0 || BitUtil.getBitBool(this.regs[0], 7) && this.register >= 6) break;
                        this.regs[3] = 0;
                        this.writeBankData(value);
                        break;
                    }
                    this.setNametableMirroring(value & 1);
                    break;
                }
                case 40961: {
                    if (this.regs[2] != 0) {
                        this.setNametableMirroring(value & 1);
                        break;
                    }
                    this.writePrgRamProtect(value);
                    break;
                }
                default: {
                    super.writeRegister(address, value);
                }
            }
        }
    }
}

