/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class Mapper294
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private int outerBank;

    public Mapper294(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.outerBank = 0;
        this.setNametableMirroring(1);
        this.updateState();
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        if (BitUtil.getBitBool(this.outerBank, 2)) {
            this.setPrgBlock(this.outerBank & 0xF0, 15);
            this.setChrBlock((this.outerBank & 0xF0) << 3, 127);
        } else {
            this.setPrgBlock(this.outerBank & 0xE0, 31);
            this.setChrBlock(0, 255);
        }
    }

    private void writeOuterBank(int value) {
        this.outerBank = value;
        this.updateState();
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address == 24577) {
            this.writeOuterBank(value);
        }
        super.writeMemory(address, value);
    }
}

