/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.piratemmc3;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.mappers.nintendo.fds.FdsAudio;
import nintaco.util.BitUtil;

public class Mapper353
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private final FdsAudio audio = new FdsAudio();
    private int outer;
    private int mirroring;

    public Mapper353(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.mirroring = 0;
        this.writeOuterBankRegister(0);
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public int readMemory(int address) {
        int value = this.audio.readRegister(address);
        return value >= 0 ? value : super.readMemory(address);
    }

    private void writeOuterBankRegister(int address) {
        this.outer = address >> 13 & 3;
        this.updateState();
    }

    private void updateState() {
        if (this.outer == 2) {
            this.setPrgBlock(this.outer << 5 | (this.R[0] & 0x80) >> 3, 15);
        } else {
            this.setPrgBlock(this.outer << 5, 31);
        }
        if (this.outer == 2 && BitUtil.getBitBool(this.R[0], 7)) {
            this.chrRamPresent = true;
        } else {
            this.chrRamPresent = false;
            this.setChrBlock(this.outer << 7, 127);
        }
        this.updateBanks();
    }

    @Override
    public void writeMemory(int address, int value) {
        if (!this.audio.writeRegister(address, value) && (address & 0x8080) == 32896) {
            this.writeOuterBankRegister(address);
        }
        super.writeMemory(address, value);
    }

    @Override
    protected void writeMirroring(int value) {
        this.mirroring = value;
        if (this.outer != 0) {
            super.writeMirroring(value);
        }
    }

    @Override
    protected void updatePrgBanks() {
        super.updatePrgBanks();
        if (this.outer == 3 && !BitUtil.getBitBool(this.R[0], 7)) {
            this.setPrgBank(6, 0x70 | this.R[6]);
            this.setPrgBank(7, 0x70 | this.R[7]);
        }
    }

    @Override
    protected void updateChrBanks() {
        super.updateChrBanks();
        if (this.outer == 0) {
            if (this.chrMode) {
                this.setNametable(0, this.R[2]);
                this.setNametable(1, this.R[3]);
                this.setNametable(2, this.R[4]);
                this.setNametable(3, this.R[5]);
            } else {
                this.setNametable(0, this.R[0]);
                this.setNametable(1, this.R[0]);
                this.setNametable(2, this.R[1]);
                this.setNametable(3, this.R[1]);
            }
        } else {
            super.writeMirroring(this.mirroring);
        }
    }

    @Override
    public void setNametable(int index, int value) {
        this.nametableMappings[index] = 0x2000 | (value & 0x80) << 3;
    }

    @Override
    public void update() {
        this.audio.update();
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }

    @Override
    public int getAudioMixerScale() {
        return this.audio.getAudioMixerScale();
    }
}

