/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.sachen;

import nintaco.files.CartFile;
import nintaco.mappers.sachen.Sachen8259;

public class Sachen8259B
extends Sachen8259 {
    private static final long serialVersionUID = 0L;

    public Sachen8259B(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    protected void writeRegisterData(int value) {
        value &= 7;
        switch (this.register) {
            case 0: {
                this.writeChrSelect(0, value);
                break;
            }
            case 1: {
                this.writeChrSelect(1, value);
                break;
            }
            case 2: {
                this.writeChrSelect(2, value);
                break;
            }
            case 3: {
                this.writeChrSelect(3, value);
                break;
            }
            case 4: {
                for (int i = 0; i < 4; ++i) {
                    this.writeChrTopBits(i, value);
                }
                break;
            }
            case 5: {
                this.setPrgBank(value);
                break;
            }
            case 7: {
                this.writeModeAndMirroringSelect(value);
            }
        }
    }

    protected void writeChrTopBits(int bank, int value) {
        this.chrRegs[bank] = this.chrRegs[bank] & 0xC7 | (value & 7) << 3;
        this.updateChrBanks();
    }

    @Override
    protected void updateChrBanks() {
        for (int i = 3; i >= 0; --i) {
            this.chrBanks[i] = this.chrRegs[this.simpleMode ? 0 : i] << 11;
        }
    }
}

