/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.subor;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper166
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected int outerBank;
    protected int mode;
    protected int innerBank1;
    protected int innerBank2;

    public Mapper166(CartFile cartFile) {
        super(cartFile, 4, 0);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xE000) {
            case 32768: {
                this.writeOuterBank(value);
                break;
            }
            case 40960: {
                this.writeMode(value);
                break;
            }
            case 49152: {
                this.writeInnerBank1(value);
                break;
            }
            case 57344: {
                this.writeInnerBank2(value);
            }
        }
    }

    protected void writeOuterBank(int value) {
        this.outerBank = value;
        this.updateBanks();
    }

    protected void writeMode(int value) {
        this.mode = value;
        this.updateBanks();
    }

    protected void writeInnerBank1(int value) {
        this.innerBank1 = value;
        this.updateBanks();
    }

    protected void writeInnerBank2(int value) {
        this.innerBank2 = value;
        this.updateBanks();
    }

    protected void updateBanks() {
        int outer512 = ((this.outerBank ^ this.mode) & 0x10) << 1;
        int inner16 = (this.innerBank1 ^ this.innerBank2) & 0x1F;
        int bank = outer512 | inner16;
        switch (this.mode & 0xF) {
            case 0: {
                this.updateUNROM(bank);
                break;
            }
            case 4: {
                this.updateInvertedUNROM(bank);
                break;
            }
            case 8: 
            case 12: {
                this.updateNROM(bank);
            }
        }
    }

    protected void updateUNROM(int bank) {
        this.setPrgBank(2, bank);
        this.setPrgBank(3, 7);
    }

    protected void updateInvertedUNROM(int bank) {
        this.setPrgBank(2, 31);
        this.setPrgBank(3, bank);
    }

    protected void updateNROM(int bank) {
        this.setPrgBank(2, bank & 0xFE);
        this.setPrgBank(3, bank | 1);
    }
}

