/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.sunsoft.fme7;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.mappers.sunsoft.fme7.Sunsoft5BAudio;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;

public class SunsoftFME7
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected final Sunsoft5BAudio audio = new Sunsoft5BAudio();
    protected int command;
    protected boolean prgRamEnabled;
    protected boolean usePrgRam;
    protected int irqCounter;
    protected boolean irqEnabled;
    protected boolean irqCounterEnabled;

    public SunsoftFME7(CartFile cartFile) {
        super(cartFile, 8, 8);
        this.setPrgBank(7, -1);
        this.audio.init();
    }

    @Override
    public void setTVSystem(TVSystem tvSystem) {
        super.setTVSystem(tvSystem);
        this.audio.setTVSystem(tvSystem);
    }

    @Override
    public int readMemory(int address) {
        if (address < 32768) {
            if (address >= 24576) {
                if (this.usePrgRam) {
                    return this.prgRamEnabled ? this.memory[address] : 0;
                }
                return this.prgROM[(this.prgBanks[3] | address & 0x1FFF) & this.prgRomSizeMask];
            }
            return this.memory[address];
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (this.audio.writeRegister(address, value)) {
            return;
        }
        switch (address & 0xE000) {
            case 32768: {
                this.writeCommand(value);
                break;
            }
            case 40960: {
                this.writeParameter(value);
                break;
            }
            default: {
                if (address >= 24576 && (!this.prgRamEnabled || !this.usePrgRam)) break;
                this.memory[address] = value;
            }
        }
    }

    private void writeCommand(int value) {
        this.command = 0xF & value;
    }

    private void writeParameter(int value) {
        switch (this.command) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.setChrBank(this.command, value);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.writePrgBank(this.command - 5, value);
                break;
            }
            case 12: {
                this.setNametableMirroring(value & 3);
                break;
            }
            case 13: {
                this.writeIrqControl(value);
                break;
            }
            case 14: {
                this.writeIrqCounterLow(value);
                break;
            }
            case 15: {
                this.writeIrqCounterHigh(value);
            }
        }
    }

    private void writeIrqCounterLow(int value) {
        this.irqCounter = this.irqCounter & 0xFF00 | value;
    }

    private void writeIrqCounterHigh(int value) {
        this.irqCounter = this.irqCounter & 0xFF | value << 8;
    }

    private void writeIrqControl(int value) {
        this.irqEnabled = BitUtil.getBitBool(value, 0);
        this.irqCounterEnabled = BitUtil.getBitBool(value, 7);
        this.cpu.setMapperIrq(false);
    }

    private void writePrgBank(int bank, int value) {
        this.setPrgBank(bank, value & 0x3F);
        if (bank == 3) {
            this.usePrgRam = BitUtil.getBitBool(value, 6);
            this.prgRamEnabled = BitUtil.getBitBool(value, 7);
        }
    }

    @Override
    public void update() {
        if (this.irqCounterEnabled) {
            this.irqCounter = this.irqCounter - 1 & 0xFFFF;
            if (this.irqCounter == 65535 && this.irqEnabled) {
                this.cpu.setMapperIrq(true);
            }
        }
        this.audio.update();
    }

    @Override
    public int getAudioMixerScale() {
        return this.audio.getAudioMixerScale();
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }
}

