/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.taito;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class X1005
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected boolean ramEnabled;

    public X1005(CartFile cartFile) {
        super(cartFile, 8, 8);
        this.setPrgBank(7, -1);
    }

    @Override
    public int readMemory(int address) {
        if (address >= 32512 && address < 32768) {
            return this.ramEnabled ? this.memory[address & 0x7F7F] : 0;
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 32512 && address < 32768) {
            if (this.ramEnabled) {
                this.memory[address & 0x7F7F] = value;
            }
        } else {
            switch (address) {
                case 32496: {
                    this.writeChrBank(0, value);
                    break;
                }
                case 32497: {
                    this.writeChrBank(2, value);
                    break;
                }
                case 32498: {
                    this.writeChrBank(4, value);
                    break;
                }
                case 32499: {
                    this.writeChrBank(5, value);
                    break;
                }
                case 32500: {
                    this.writeChrBank(6, value);
                    break;
                }
                case 32501: {
                    this.writeChrBank(7, value);
                    break;
                }
                case 32502: 
                case 32503: {
                    this.setNametableMirroring(value & 1 ^ 1);
                    break;
                }
                case 32504: 
                case 32505: {
                    this.ramEnabled = 163 == value;
                    break;
                }
                case 32506: 
                case 32507: {
                    this.setPrgBank(4, value);
                    break;
                }
                case 32508: 
                case 32509: {
                    this.setPrgBank(5, value);
                    break;
                }
                case 32510: 
                case 32511: {
                    this.setPrgBank(6, value);
                    break;
                }
                default: {
                    this.memory[address] = value;
                }
            }
        }
    }

    protected void writeChrBank(int bank, int value) {
        value <<= 10;
        if (bank < 4) {
            this.chrBanks[bank] = value;
            this.chrBanks[bank + 1] = value + 1024;
        } else {
            this.chrBanks[bank] = value;
        }
    }
}

