/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class BMC1024CA1
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private boolean outerBankLocked;

    public BMC1024CA1(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.writeOuterBank(0);
    }

    private void writeOuterBank(int address) {
        int outerBank = address & 7;
        if (outerBank > 0) {
            this.outerBankLocked = true;
        }
        if (BitUtil.getBitBool(address, 3)) {
            this.setPrgBlock(outerBank << 4, 31);
        } else {
            this.setPrgBlock(outerBank << 4, 15);
        }
        this.chrRamPresent = BitUtil.getBitBool(address, 4);
        if (this.chrRamPresent) {
            this.setChrBlock(0, -1);
        } else if (BitUtil.getBitBool(address, 5)) {
            this.setChrBlock(outerBank << 7, 255);
        } else {
            this.setChrBlock(outerBank << 7, 127);
        }
        this.updateBanks();
    }

    @Override
    public void writeMemory(int address, int value) {
        if (!this.outerBankLocked && this.prgRamChipEnabled && this.prgRamWritesEnabled && (address & 0xE000) == 24576) {
            this.writeOuterBank(address);
        }
        super.writeMemory(address, value);
    }
}

