/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMC70In1
extends Mapper {
    private static final long serialVersionUID = 0L;
    protected int hardwareSwitch;
    protected int largeBank;
    protected int prgBank;
    protected int chrBank;
    protected int bankMode;
    protected int mirroring;

    public BMC70In1(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.initHardwareSwitch();
        this.setChrBank(0);
        this.bankMode = 0;
        this.largeBank = 0;
        this.updateBanks();
    }

    protected void initHardwareSwitch() {
        this.hardwareSwitch = 13;
    }

    @Override
    public void resetting() {
        this.init();
        ++this.hardwareSwitch;
        this.hardwareSwitch &= 0xF;
    }

    private void updateBanks() {
        switch (this.bankMode) {
            case 0: 
            case 16: {
                this.setPrgBank(2, this.largeBank | this.prgBank);
                this.setPrgBank(3, this.largeBank | 7);
                break;
            }
            case 32: {
                int b = (this.largeBank | this.prgBank) & 0xFE;
                this.setPrgBank(2, b);
                this.setPrgBank(3, b | 1);
                break;
            }
            case 48: {
                this.setPrgBank(2, this.largeBank | this.prgBank);
                this.setPrgBank(3, this.largeBank | this.prgBank);
            }
        }
        this.setNametableMirroring(this.mirroring);
        this.updateChrBanks();
    }

    protected void updateChrBanks() {
        this.setChrBank(this.chrBank);
    }

    @Override
    public int readMemory(int address) {
        if (address >= 32768 && this.bankMode == 16) {
            address = address & 0xFFF0 | this.hardwareSwitch;
        }
        return super.readMemory(address);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (BitUtil.getBitBool(address, 14)) {
            this.bankMode = address & 0x30;
            this.prgBank = address & 7;
        } else {
            this.mirroring = (address & 0x20) >> 5;
            this.setLargeBank(address);
        }
        this.updateBanks();
    }

    protected void setLargeBank(int address) {
        this.chrBank = address & 7;
    }
}

