/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class BMC891227
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int reg;

    public BMC891227(CartFile cartFile) {
        super(cartFile, 8, 1, 32768, 24576);
    }

    @Override
    public void init() {
        this.reg = 0;
        this.setPrgBank(3, 1);
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        switch (this.reg & 0x60) {
            case 32: {
                this.set4PrgBanks(4, (this.reg & 0x1F) << 1);
                break;
            }
            case 64: 
            case 96: {
                this.set2PrgBanks(4, (this.reg & 0x3F) << 1);
                this.set2PrgBanks(6, (this.reg & 0x38 | 7) << 1);
                break;
            }
            default: {
                this.set2PrgBanks(4, (this.reg & 0x1F) << 1);
                this.set2PrgBanks(6, (this.reg & 0x1F) << 1);
            }
        }
        this.setNametableMirroring(BitUtil.getBit(this.reg, 7));
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address >= 8192 || (this.reg & 0x40) != 0) {
            this.vram[address] = value;
        }
    }

    private void writeOuterBankRegister(int value) {
        this.reg = value & 0xF8 | this.reg & 7;
        this.updateState();
    }

    private void writeInnerBankRegister(int value) {
        this.reg = this.reg & 0xF8 | value & 7;
        this.updateState();
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address >= 49152) {
            this.writeInnerBankRegister(value);
        } else {
            this.writeOuterBankRegister(value);
        }
    }
}

