/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.fds.FdsAudio;
import nintaco.util.BitUtil;

public class BMCSB5013
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[] MASKS = new int[]{63, 31, 47, 15};
    private final FdsAudio audio = new FdsAudio();
    private final int[] prg = new int[4];
    private int offset;
    private int mask;
    private int irqLatch;
    private int irqLatency;
    private int irqCounter;
    private boolean irqReload;
    private boolean irqEnabled;
    private boolean PA12Mode;
    private boolean irqAutoEnable;

    public BMCSB5013(CartFile cartFile) {
        super(cartFile, 8, 1, 32768, 24576);
    }

    @Override
    public void init() {
        this.prg[0] = 3;
        this.prg[1] = 0;
        this.prg[2] = 1;
        this.prg[3] = 2;
        this.mask = 63;
        this.irqCounter = 0;
        this.offset = 0;
        this.irqAutoEnable = false;
        this.PA12Mode = false;
        this.irqEnabled = false;
        this.irqReload = false;
        this.setNametableMirroring(0);
        this.cpu.setMapperIrq(false);
        this.audio.reset();
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateState() {
        this.setPrgBank(3, this.offset | this.mask & this.prg[0]);
        this.setPrgBank(4, this.offset | this.mask & this.prg[1]);
        this.setPrgBank(5, this.offset | this.mask & this.prg[2]);
        this.setPrgBank(6, this.offset | this.mask & this.prg[3]);
        this.setPrgBank(7, this.offset | this.mask & 0xFF);
    }

    private void writePrgBankSelect(int index, int value) {
        this.prg[index] = value;
        this.updateState();
    }

    private void writePrgBaseSelect(int value) {
        this.offset = (value & 0x38) << 1;
        this.updateState();
    }

    private void writeOuterBankSizeSelect(int value) {
        this.mask = MASKS[value & 3];
        this.updateState();
    }

    private void writeNametableMirroringTypeSelect(int value) {
        this.setNametableMirroring(value & 3);
    }

    private void writeIrqCounterLowReload(int value) {
        if (this.irqAutoEnable) {
            this.irqEnabled = false;
        }
        if (this.PA12Mode) {
            this.irqReload = true;
            this.irqCounter = 0;
        } else {
            this.irqCounter = this.irqCounter & 0xFF00 | value;
        }
        this.cpu.setMapperIrq(false);
    }

    private void writeIrqCounterHighLoadLatch(int value) {
        if (this.irqAutoEnable) {
            this.irqEnabled = true;
        }
        if (this.PA12Mode) {
            this.irqLatch = value;
        } else {
            this.irqCounter = value << 8 | this.irqCounter & 0xFF;
        }
        this.cpu.setMapperIrq(false);
    }

    private void writeIrqMode(int value) {
        this.irqAutoEnable = BitUtil.getBitBool(value, 2);
        this.PA12Mode = BitUtil.getBitBool(value, 1);
        this.irqEnabled = BitUtil.getBitBool(value, 0);
        this.cpu.setMapperIrq(false);
    }

    private void writeIrqDisableEnable(int value) {
        this.irqEnabled = BitUtil.getBitBool(value, 0);
        this.cpu.setMapperIrq(false);
    }

    @Override
    public int readMemory(int address) {
        int value = this.audio.readRegister(address);
        return value >= 0 ? value : super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        super.writeMemory(address, value);
        this.audio.writeRegister(address, value);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF003) {
            case 32768: {
                this.writePrgBankSelect(1, value);
                break;
            }
            case 32769: {
                this.writePrgBankSelect(2, value);
                break;
            }
            case 32770: {
                this.writePrgBankSelect(3, value);
                break;
            }
            case 32771: {
                this.writePrgBankSelect(0, value);
                break;
            }
            case 36864: {
                this.writePrgBaseSelect(value);
                break;
            }
            case 36865: {
                this.writeOuterBankSizeSelect(value);
                break;
            }
            case 36866: {
                this.writeNametableMirroringTypeSelect(value);
                break;
            }
            case 49152: {
                this.writeIrqCounterLowReload(value);
                break;
            }
            case 49153: {
                this.writeIrqCounterHighLoadLatch(value);
                break;
            }
            case 49154: {
                this.writeIrqMode(value);
                break;
            }
            case 49155: {
                this.writeIrqDisableEnable(value);
            }
        }
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        if (this.irqLatency != 0) {
            --this.irqLatency;
        }
        if ((address & 0x1000) != 0) {
            if (this.PA12Mode && this.irqLatency != 0) {
                if (this.irqReload || (this.irqCounter & 0xFF) == 0) {
                    this.irqCounter = this.irqCounter & 0xFF00 | this.irqLatch;
                    this.irqReload = false;
                } else {
                    this.irqCounter = this.irqCounter & 0xFF00 | this.irqLatch - 1 & 0xFF;
                }
                if (this.irqEnabled && (this.irqCounter & 0xFF) == 0) {
                    this.cpu.setMapperIrq(true);
                }
            }
            this.irqLatency = 8;
        }
    }

    @Override
    public void update() {
        this.audio.update();
        if (this.irqEnabled && !this.PA12Mode) {
            --this.irqCounter;
            this.irqCounter &= 0xFFFF;
            if (this.irqCounter == 0) {
                this.cpu.setMapperIrq(true);
            }
        }
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }

    @Override
    public int getAudioMixerScale() {
        return this.audio.getAudioMixerScale();
    }
}

