/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Ghostbusters63In1
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[2];
    private boolean registerEnabled;

    public Ghostbusters63In1(CartFile cartFile) {
        super(cartFile, 4, 1);
    }

    @Override
    public void init() {
        this.registerEnabled = true;
        this.regs[0] = 0;
        this.regs[1] = 0;
        this.setChrBank(0);
        this.updateBanks();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updateBanks() {
        int offset = (this.regs[1] << 5 & 0x20) << (this.regs[0] >> 7);
        if (offset < this.regs[0] >> 7) {
            this.registerEnabled = false;
        } else {
            this.setPrgBank(2, offset | this.regs[0] & 0x1E | this.regs[0] >> 5 & this.regs[0]);
            this.setPrgBank(3, offset | this.regs[0] & 0x1F | ~this.regs[0] >> 5 & 1);
        }
        this.setNametableMirroring(BitUtil.getBit(this.regs[0], 6) ^ 1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (this.registerEnabled) {
            this.regs[address & 1] = value;
            this.updateBanks();
        }
    }
}

