/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.bmc;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Supervision16In1
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int game;
    private int data;

    public Supervision16In1(CartFile cartFile) {
        super(cartFile, 8, 1, 24576, 24576);
    }

    private void updateBanks() {
        this.setPrgBank(3, (this.game & 0xF) << 4 | 0xF);
        if (BitUtil.getBitBool(this.game, 4)) {
            this.setPrgBanks(4, 2, ((this.game & 0xF) << 3 | this.data) << 1);
            this.setPrgBanks(6, 2, ((this.game & 0xF) << 3 | 7) << 1);
        } else {
            this.setPrgBanks(4, 4, 256);
        }
        this.setChrBank(0);
        this.setNametableMirroring(BitUtil.getBit(this.game, 5));
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (!BitUtil.getBitBool(this.game, 4)) {
            this.game = value & 0x3F;
        }
        this.data = value & 7;
        this.updateBanks();
    }
}

