/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class BJ56
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int irqCounter;

    public BJ56(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.setNametableMirroring(0);
        this.set4PrgBanks(4, 252);
    }

    private void writeChrRomBankSelect(int address, int value) {
        this.setChrBank(address & 7, value);
    }

    private void writePrgRomBankSelect(int address, int value) {
        this.setPrgBank(4 | address & 3, value);
    }

    private void resetIrqCounter() {
        this.irqCounter = 0;
    }

    private void acknowledgeIrq() {
        this.cpu.setMapperIrq(false);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (address < 32776) {
            this.writeChrRomBankSelect(address, value);
        } else if (address < 32780) {
            this.writePrgRomBankSelect(address, value);
        } else if (address == 32781) {
            this.resetIrqCounter();
        } else if (address == 32783) {
            this.acknowledgeIrq();
        }
    }

    @Override
    public void update() {
        if ((++this.irqCounter & 0x1000) != 0) {
            this.cpu.setMapperIrq(true);
        }
    }
}

