/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class H2288
extends MMC3 {
    private static final long serialVersionUID = 0L;
    private static final int[] REGISTERS = new int[]{0, 3, 1, 5, 6, 7, 2, 4};
    private int reg;

    public H2288(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void writeMemory(int address, int value) {
        if ((address & 0xF801) == 22528) {
            this.reg = value;
            this.updateBanks();
        } else {
            super.writeMemory(address, value);
        }
    }

    @Override
    protected void writeBankSelect(int value) {
        super.writeBankSelect(value & 0xF8 | REGISTERS[value & 7]);
    }

    @Override
    protected void updateBanks() {
        if (BitUtil.getBitBool(this.reg, 6)) {
            int bank = (this.reg & 5 | (this.reg & 8) >> 2 | (this.reg & 0x20) >> 2) << 1;
            if (BitUtil.getBitBool(this.reg, 1)) {
                this.setPrgBank(4, bank &= 0xFC);
                this.setPrgBank(5, bank | 1);
                this.setPrgBank(6, bank | 2);
                this.setPrgBank(7, bank | 3);
            } else {
                this.setPrgBank(4, bank &= 0xFE);
                this.setPrgBank(5, bank | 1);
                this.setPrgBank(6, bank);
                this.setPrgBank(7, bank | 1);
            }
        } else {
            this.updatePrgBanks();
        }
        this.updateChrBanks();
    }
}

