/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import java.util.Arrays;
import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class OneBus_Old
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[] midX = new int[]{0, 1, 2, 0, 3, 4, 5, 0};
    private final int[] cpu410x = new int[16];
    private final int[] ppu201x = new int[16];
    private final int[] apu40xx = new int[64];
    private final int pcmClock = 246;
    private int irqCounter;
    private boolean irqEnabled;
    private boolean irqReloadRequest;
    private int irqResetDelay;
    private int invertHack = 0;
    private boolean pcmEnable;
    private int pcmIRQ;
    private int pcmAddress;
    private int pcmSize;
    private int pcmLatch;

    public OneBus_Old(CartFile cartFile) {
        super(cartFile, 8, 8);
        if (cartFile.getFileCRC() == 811584963 || cartFile.getFileCRC() == 1790955150) {
            this.invertHack = 15;
        }
    }

    @Override
    public void init() {
        this.updateBanks();
    }

    @Override
    public void resetting() {
        this.irqReloadRequest = false;
        this.irqCounter = 0;
        this.irqEnabled = false;
        Arrays.fill(this.cpu410x, 0);
        Arrays.fill(this.ppu201x, 0);
        Arrays.fill(this.apu40xx, 0);
        this.updateBanks();
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192) {
            return this.prgROM[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.prgRomSizeMask];
        }
        return this.vram[address];
    }

    private void updatePrgBanks() {
        int bankmode = this.cpu410x[11] & 7;
        int mask = bankmode == 7 ? 255 : 63 >> bankmode;
        int block = ((this.cpu410x[0] & 0xF0) << 4) + (this.cpu410x[10] & ~mask);
        int swap = (this.cpu410x[5] & 0x40) >> 5;
        int bank0 = this.cpu410x[7 ^ this.invertHack];
        int bank1 = this.cpu410x[8 ^ this.invertHack];
        int bank2 = (this.cpu410x[11] & 0x40) != 0 ? this.cpu410x[9] : -2;
        int bank3 = -1;
        this.setPrgBank(4 ^ swap, block | bank0 & mask);
        this.setPrgBank(5, block | bank1 & mask);
        this.setPrgBank(6 ^ swap, block | bank2 & mask);
        this.setPrgBank(7, block | 0xFFFFFFFF & mask);
    }

    private void updateChrBanks() {
        int mask = 255 >> midX[this.ppu201x[10] & 7];
        int block = ((this.cpu410x[0] & 0xF) << 11) + ((this.ppu201x[8] & 0x70) << 4) + (this.ppu201x[10] & ~mask);
        int swap = (this.cpu410x[5] & 0x80) >> 5;
        int bank0 = this.ppu201x[6] & 0xFFFFFFFE;
        int bank1 = this.ppu201x[6] | 1;
        int bank2 = this.ppu201x[7] & 0xFFFFFFFE;
        int bank3 = this.ppu201x[7] | 1;
        int bank4 = this.ppu201x[2];
        int bank5 = this.ppu201x[3];
        int bank6 = this.ppu201x[4];
        int bank7 = this.ppu201x[5];
        this.setChrBank(0 ^ swap, block | bank0 & mask);
        this.setChrBank(1 ^ swap, block | bank1 & mask);
        this.setChrBank(2 ^ swap, block | bank2 & mask);
        this.setChrBank(3 ^ swap, block | bank3 & mask);
        this.setChrBank(4 ^ swap, block | bank4 & mask);
        this.setChrBank(5 ^ swap, block | bank5 & mask);
        this.setChrBank(6 ^ swap, block | bank6 & mask);
        this.setChrBank(7 ^ swap, block | bank7 & mask);
        this.setNametableMirroring(this.cpu410x[6] & 1);
    }

    private void updateBanks() {
        this.updatePrgBanks();
        this.updateChrBanks();
    }

    @Override
    public int readCpuMemory(int address) {
        if ((address &= 0xFFFF) == 16405) {
            int result = this.apu.readStatus();
            if ((this.apu40xx[48] & 0x10) != 0) {
                result = result & 0x7F | this.pcmIRQ;
            }
            return result;
        }
        return super.readCpuMemory(address);
    }

    @Override
    public void writeCpuMemory(int address, int value) {
        value &= 0xFF;
        if (((address &= 0xFFFF) & 0xFFF0) == 8208) {
            this.ppu201x[address & 0xF] = value;
            this.updateBanks();
        } else {
            if ((address & 0xFFF0) == 16640) {
                switch (address & 0xF) {
                    case 1: {
                        this.cpu410x[1] = value & 0xFE;
                        break;
                    }
                    case 2: {
                        this.irqReloadRequest = true;
                        break;
                    }
                    case 3: {
                        this.cpu.setMapperIrq(false);
                        this.irqEnabled = false;
                        break;
                    }
                    case 4: {
                        this.irqEnabled = true;
                        break;
                    }
                    default: {
                        this.cpu410x[address & 0xF] = value;
                        this.updateBanks();
                        break;
                    }
                }
            } else if ((address & 0xFFC0) == 16384) {
                this.apu40xx[address & 0x3F] = value;
                switch (address & 0x3F) {
                    case 18: {
                        if ((this.apu40xx[48] & 0x10) == 0) break;
                        this.pcmAddress = value << 6;
                        break;
                    }
                    case 19: {
                        if ((this.apu40xx[48] & 0x10) == 0) break;
                        this.pcmSize = (value << 4) + 1;
                        break;
                    }
                    case 21: {
                        if ((this.apu40xx[48] & 0x10) == 0) break;
                        boolean bl = this.pcmEnable = (value & 0x10) != 0;
                        if (this.pcmIRQ != 0) {
                            this.cpu.setMapperIrq(false);
                            this.pcmIRQ = 0;
                        }
                        if (this.pcmEnable) {
                            this.pcmLatch = 246;
                        }
                        value &= 0xEF;
                    }
                }
            }
            super.writeCpuMemory(address, value);
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xE001) {
            case 32768: {
                this.cpu410x[5] = this.cpu410x[5] & 0x38 | value & 0xC7;
                this.updateBanks();
                break;
            }
            case 32769: {
                switch (this.cpu410x[5] & 7) {
                    case 0: {
                        this.ppu201x[6] = value;
                        this.updateChrBanks();
                        break;
                    }
                    case 1: {
                        this.ppu201x[7] = value;
                        this.updateChrBanks();
                        break;
                    }
                    case 2: {
                        this.ppu201x[2] = value;
                        this.updateChrBanks();
                        break;
                    }
                    case 3: {
                        this.ppu201x[3] = value;
                        this.updateChrBanks();
                        break;
                    }
                    case 4: {
                        this.ppu201x[4] = value;
                        this.updateChrBanks();
                        break;
                    }
                    case 5: {
                        this.ppu201x[5] = value;
                        this.updateChrBanks();
                        break;
                    }
                    case 6: {
                        this.cpu410x[7] = value;
                        this.updatePrgBanks();
                        break;
                    }
                    case 7: {
                        this.cpu410x[8] = value;
                        this.updatePrgBanks();
                    }
                }
                break;
            }
            case 40960: {
                this.cpu410x[6] = value;
                this.updateChrBanks();
                break;
            }
            case 49152: {
                this.cpu410x[1] = value & 0xFE;
                break;
            }
            case 49153: {
                this.irqReloadRequest = true;
                break;
            }
            case 57344: {
                this.cpu.setMapperIrq(false);
                this.irqEnabled = false;
                break;
            }
            case 57345: {
                this.irqEnabled = true;
            }
        }
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        boolean a12;
        if (this.irqResetDelay > 0) {
            --this.irqResetDelay;
        }
        boolean bl = a12 = (address & 0x1000) != 0;
        if (a12 && this.irqResetDelay == 0) {
            this.irqCounter = this.irqCounter > 0 ? --this.irqCounter : this.cpu410x[1];
            if (this.irqReloadRequest) {
                this.irqReloadRequest = false;
                this.irqCounter = this.cpu410x[1];
            }
            if (this.irqCounter == 0 && this.irqEnabled) {
                this.cpu.setMapperIrq(true);
            }
        }
        if (a12) {
            this.irqResetDelay = 8;
        }
    }

    @Override
    public void update() {
        if (this.pcmEnable) {
            --this.pcmLatch;
            if (this.pcmLatch <= 0) {
                this.pcmLatch += 246;
                --this.pcmSize;
                if (this.pcmSize < 0) {
                    this.pcmIRQ = 128;
                    this.pcmEnable = false;
                    this.cpu.setMapperIrq(true);
                } else {
                    int rawPcm = this.readMemory(this.pcmAddress);
                    this.apu.dmc.writeDirectLoad(rawPcm);
                    ++this.pcmAddress;
                    this.pcmAddress &= Short.MAX_VALUE;
                }
            }
        }
    }
}

