/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.unif.unl;

import nintaco.files.CartFile;
import nintaco.mappers.nintendo.MMC3;
import nintaco.util.BitUtil;

public class UNL8237
extends MMC3 {
    private static final long serialVersionUID = 0L;
    protected static final int[][] registerLUT = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 2, 6, 1, 7, 3, 4, 5}, {0, 5, 4, 1, 7, 2, 6, 3}, {0, 6, 3, 7, 5, 2, 4, 1}, {0, 2, 5, 3, 6, 1, 7, 4}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}};
    protected static final int[][] addressLUT = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {3, 2, 0, 4, 1, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {5, 0, 1, 2, 3, 7, 6, 4}, {3, 1, 0, 5, 2, 4, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}};
    protected final int[] regs = new int[3];

    public UNL8237(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        this.regs[0] = 0;
        this.regs[1] = 3;
        this.regs[2] = 0;
        super.init();
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 32768) {
            int adr = addressLUT[this.regs[2]][address >> 12 & 6 | address & 1];
            address = adr & 1 | (adr & 6) << 12 | 0x8000;
            if (adr == 0) {
                value = value & 0xC0 | registerLUT[this.regs[2]][value & 7];
            }
        } else {
            switch (address) {
                case 20480: {
                    this.regs[0] = value;
                    this.updateBanks();
                    break;
                }
                case 20481: {
                    this.regs[1] = value;
                    this.updateBanks();
                    break;
                }
                case 20487: {
                    this.regs[2] = value;
                }
            }
        }
        super.writeMemory(address, value);
    }

    @Override
    protected void setPrgBank(int bank, int value) {
        if (BitUtil.getBitBool(this.regs[0], 6)) {
            int sbank = this.regs[1] & 0x10;
            if (BitUtil.getBitBool(this.regs[0], 7)) {
                int b = (this.regs[1] & 3) << 4 | this.regs[0] & 7 | sbank >> 1;
                if (BitUtil.getBitBool(this.regs[0], 5)) {
                    int B = b >> 1 << 2;
                    super.setPrgBank(4, B);
                    super.setPrgBank(5, B | 1);
                    super.setPrgBank(6, B | 2);
                    super.setPrgBank(7, B | 3);
                } else {
                    int B = b << 1;
                    super.setPrgBank(4, B);
                    super.setPrgBank(5, B | 1);
                    super.setPrgBank(6, B);
                    super.setPrgBank(7, B | 1);
                }
            } else {
                super.setPrgBank(bank, (this.regs[1] & 3) << 5 | sbank | value & 0xF);
            }
        } else if (BitUtil.getBitBool(this.regs[0], 7)) {
            int b = (this.regs[1] & 3) << 4 | this.regs[0] & 0xF;
            if (BitUtil.getBitBool(this.regs[0], 5)) {
                int B = b >> 1 << 2;
                super.setPrgBank(4, B);
                super.setPrgBank(5, B | 1);
                super.setPrgBank(6, B | 2);
                super.setPrgBank(7, B | 3);
            } else {
                int B = b << 1;
                super.setPrgBank(4, B);
                super.setPrgBank(5, B | 1);
                super.setPrgBank(6, B);
                super.setPrgBank(7, B | 1);
            }
        } else {
            super.setPrgBank(bank, (this.regs[1] & 3) << 5 | value & 0x1F);
        }
    }

    @Override
    protected void setChrBank(int bank, int value) {
        value = BitUtil.getBitBool(this.regs[0], 6) ? (this.regs[1] & 0xC) << 6 | (this.regs[1] & 0x20) << 2 | value & 0x7F : (value |= (this.regs[1] & 0xC) << 6);
        super.setChrBank(bank, value);
    }
}

