/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.waixing;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Mapper176
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean SBW;

    public Mapper176(CartFile cartFile) {
        super(cartFile, 8, 1, 20481, 32768);
    }

    @Override
    public void init() {
        super.init();
        this.SBW = false;
        this.setPrgBank(4, 0);
        this.setPrgBank(5, 1);
        this.setPrgBank(6, 62);
        this.setPrgBank(7, 63);
    }

    @Override
    public void resetting() {
        this.init();
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address) {
            case 20481: {
                if (!this.SBW) break;
                this.writePrgBanks(value);
                break;
            }
            case 20496: {
                if (value != 36) break;
                this.SBW = true;
                break;
            }
            case 20497: {
                if (!this.SBW) break;
                this.writePrgBanks(value >> 1);
                break;
            }
            case 24561: {
                this.writePrgBanks(value >> 1);
                break;
            }
            case 24562: {
                this.setChrBank(0, value);
                break;
            }
            case 40960: {
                this.setNametableMirroring(value & 3);
            }
        }
    }

    private void writePrgBanks(int value) {
        this.setBanks(this.prgBanks, 4, value << 15, 4, 8192);
    }
}

