/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.waixing;

import nintaco.files.CartFile;
import nintaco.mappers.konami.VrcIrq;

public class Mapper252
extends VrcIrq {
    private static final long serialVersionUID = 0L;
    private final int[] chrRegs = new int[8];
    private final boolean[] chrRamBanks = new boolean[8];

    public Mapper252(CartFile cartFile) {
        super(cartFile);
    }

    @Override
    public void init() {
        super.init();
        this.setPrgBank(6, -2);
        this.setPrgBank(7, -1);
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192 && this.chrAddressMask != 0) {
            int bank = address >> this.chrShift;
            if (this.chrRamBanks[bank]) {
                this.vram[(this.chrBanks[bank] | address & this.chrAddressMask) & 0x1FFF] = value;
            }
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    public int readVRAM(int address) {
        if (address < 8192 && this.chrAddressMask != 0) {
            int bank = address >> this.chrShift;
            if (this.chrRamBanks[bank]) {
                return this.vram[(this.chrBanks[bank] | address & this.chrAddressMask) & 0x1FFF];
            }
            return this.chrROM[(this.chrBanks[bank] | address & this.chrAddressMask) & this.chrRomSizeMask];
        }
        return this.vram[address];
    }

    private void updateChrBank(int address, int value) {
        int bank = ((address & 8 | address >> 8) >> 3) + 2 & 7;
        int shift = address & 4;
        this.chrRegs[bank] = this.chrRegs[bank] & 240 >> shift | (value & 0xF) << shift;
        if (this.chrRegs[bank] == 6 || this.chrRegs[bank] == 7) {
            this.chrRamBanks[bank] = true;
            this.setChrBank(bank, this.chrRegs[bank] & 1);
        } else {
            this.chrRamBanks[bank] = false;
            this.setChrBank(bank, this.chrRegs[bank]);
        }
    }

    @Override
    protected void writeRegister(int address, int value) {
        block0 : switch (address & 0xF000) {
            case 32768: {
                this.setPrgBank(4, value);
                break;
            }
            case 40960: {
                this.setPrgBank(5, value);
                break;
            }
            case 45056: 
            case 49152: 
            case 53248: 
            case 57344: {
                this.updateChrBank(address, value);
                break;
            }
            case 61440: {
                switch (address & 0xF00C) {
                    case 61440: {
                        this.writeIrqLatchLow(value);
                        break block0;
                    }
                    case 61444: {
                        this.writeIrqLatchHigh(value);
                        break block0;
                    }
                    case 61448: {
                        this.writeIrqControl(value);
                        break block0;
                    }
                    case 61452: {
                        this.writeIrqAcknowledge();
                    }
                }
            }
        }
    }
}

