/*
 * Decompiled with CFR 0.152.
 */
package nintaco.netplay.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import nintaco.App;
import nintaco.MachineRunner;
import nintaco.files.IFile;
import nintaco.gui.netplay.server.NetplayServerPrefs;
import nintaco.input.OtherInput;
import nintaco.input.Ports;
import nintaco.movie.Movie;
import nintaco.netplay.protocol.ControllerInput;
import nintaco.netplay.protocol.FileResponse;
import nintaco.netplay.queue.QueueElement;
import nintaco.netplay.queue.RingQueue;
import nintaco.netplay.server.NetplayServer;
import nintaco.preferences.AppPrefs;
import nintaco.util.CollectionsUtil;
import nintaco.util.StreamUtil;
import nintaco.util.ThreadUtil;
import nintaco.util.VersionUtil;

public class RemoteClient
implements Runnable {
    private static final long MAX_PAUSE_TIME = TimeUnit.SECONDS.toMillis(20L);
    private static final long HEARTBEAT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final long PAUSE_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private final ControllerInput receivedControllerInput = new ControllerInput();
    private final Object writeMonitor = new Object();
    private final Object pauseMonitor = new Object();
    private final RingQueue sendQueue = new RingQueue();
    private final NetplayServer server;
    private final Socket socket;
    private final NetplayServerPrefs prefs;
    private String remoteAddress;
    private DataInputStream in;
    private DataOutputStream out;
    private boolean authenticated;
    private long pauseTime;
    private volatile Thread heartbeatThread;
    private volatile Thread sendThread;
    private volatile Thread mainThread;
    private volatile Thread pauseThread;
    private volatile int rewindTimeValue;
    private volatile int highSpeedValue;
    private volatile boolean running;
    private volatile boolean postEnabled;

    public RemoteClient(NetplayServer server, Socket socket, NetplayServerPrefs prefs) {
        this.server = server;
        this.socket = socket;
        this.prefs = prefs;
    }

    @Override
    public void run() {
        try {
            this.mainThread = Thread.currentThread();
            this.remoteAddress = String.format("[%s]", this.socket.getInetAddress().getHostAddress());
            this.server.addActivity("%s Connected.", this.remoteAddress);
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.running = true;
            this.heartbeatThread = new Thread(this::heartbeatLoop, "Netplay Server Heartbeat Thread");
            this.heartbeatThread.start();
            this.pauseThread = new Thread(this::pauseLoop, "Netplay Server Pause Thread");
            this.pauseThread.start();
            this.sendThread = new Thread(this::sendLoop, "Netplay Server Send Thread");
            this.sendThread.start();
            this.sendServerDescription();
            this.readMessageLoop();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.dispose();
        }
        this.server.removeRemoteClient(this);
        if (this.remoteAddress != null) {
            this.server.addActivity("%s Disconnected.", this.remoteAddress);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void readMessageLoop() throws Throwable {
        while (this.running) {
            this.handleMessage(this.in.readUnsignedByte());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLoop() {
        try {
            QueueElement element = new QueueElement();
            this.sendQueue.start();
            int tail = this.sendQueue.getHead();
            while (this.running) {
                if (this.sendQueue.consume(tail++, element)) {
                    Object object = this.writeMonitor;
                    synchronized (object) {
                        this.out.write(element.messageType);
                        switch (element.dataType) {
                            case INTEGER: {
                                this.out.writeInt(element.value);
                                break;
                            }
                            case BYTES: {
                                StreamUtil.writeRawByteArray(this.out, element.data);
                                break;
                            }
                            case ALL: {
                                this.out.writeInt(element.value);
                                StreamUtil.writeRawByteArray(this.out, element.data);
                            }
                        }
                        this.out.flush();
                        continue;
                    }
                }
                this.server.addActivity("%s Send underflow. Breaking connection...", this.remoteAddress);
                break;
            }
        }
        catch (Throwable t) {
            this.server.addActivity("%s Send transmission error. Breaking connection...", this.remoteAddress);
        }
        finally {
            this.kill();
        }
    }

    private void heartbeatLoop() {
        try {
            while (this.running) {
                this.sendHeartbeat();
                ThreadUtil.sleep(HEARTBEAT_MILLIS);
            }
        }
        catch (Throwable t) {
            this.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseLoop() {
        while (this.running) {
            long time;
            Object object = this.pauseMonitor;
            synchronized (object) {
                time = this.pauseTime;
            }
            if (time != 0L && System.currentTimeMillis() - time > MAX_PAUSE_TIME) {
                this.server.addActivity("%s Timeout: failed to acknowledge file. Breaking connection...", this.remoteAddress);
                this.kill();
                break;
            }
            ThreadUtil.sleep(PAUSE_MILLIS);
        }
    }

    private void handleMessage(int messageType) throws Throwable {
        block0 : switch (messageType) {
            case 0: {
                break;
            }
            case 2: {
                this.handlePasswordHash();
                break;
            }
            default: {
                if (this.prefs.isEnablePassword() && !this.authenticated) {
                    this.kill();
                    return;
                }
                switch (messageType) {
                    case 5: {
                        this.handlePlayerRequest();
                        break block0;
                    }
                    case 7: {
                        this.handleFileRequest();
                        break block0;
                    }
                    case 10: {
                        this.handleFileReceived();
                        break block0;
                    }
                    case 11: {
                        this.handleControllerInput();
                        break block0;
                    }
                    case 14: {
                        this.handleRewindTime();
                        break block0;
                    }
                    case 19: {
                        this.handleQuickSave();
                        break block0;
                    }
                    case 18: {
                        this.handleQuickLoad();
                        break block0;
                    }
                    case 21: {
                        this.handleHighSpeed();
                        break block0;
                    }
                }
                this.server.addActivity("%s Received unknown message type: %d.", this.remoteAddress, messageType);
                this.kill();
            }
        }
    }

    public int readRewindTimeValue() {
        return this.rewindTimeValue;
    }

    public int readHighSpeedValue() {
        return this.highSpeedValue;
    }

    public ControllerInput readControllerInput() {
        return this.receivedControllerInput;
    }

    private void handleControllerInput() throws Throwable {
        this.receivedControllerInput.input = this.in.readInt();
        OtherInput[] otherInputs = (OtherInput[])StreamUtil.readObject(StreamUtil.readRawByteArray(this.in));
        if (otherInputs != null) {
            this.receivedControllerInput.otherInputs = otherInputs;
        }
    }

    private void handleRewindTime() throws Throwable {
        this.rewindTimeValue = this.in.readInt();
    }

    private void handleHighSpeed() throws Throwable {
        this.highSpeedValue = this.in.readInt();
    }

    private void handleQuickLoad() throws Throwable {
        int slot = this.in.readInt();
        if (slot == 0) {
            this.server.addActivity("%s Quick loaded from newest slot.", this.remoteAddress);
        } else {
            this.server.addActivity("%s Quick loaded from slot %d.", this.remoteAddress, slot);
        }
        App.getImageFrame().quickLoadState(slot);
    }

    private void handleQuickSave() throws Throwable {
        int slot = this.in.readInt();
        if (slot == 0) {
            this.server.addActivity("%s Quick saved to oldest slot.", this.remoteAddress);
        } else {
            this.server.addActivity("%s Quick saved to slot %d.", this.remoteAddress, slot);
        }
        App.getImageFrame().quickSaveState(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFileReceived() throws Throwable {
        int fileRequestID = this.in.readInt();
        this.server.addActivity("%s Acknowledged file transfer.", this.remoteAddress);
        Object object = this.writeMonitor;
        synchronized (object) {
            this.postEnabled = true;
            if (this.server.resume(this, fileRequestID)) {
                this.resetPauseTime();
            } else {
                this.postEnabled = false;
            }
        }
    }

    private void handlePasswordHash() throws Throwable {
        byte[] passwordHash = StreamUtil.readRawByteArray(this.in);
        this.server.addActivity("%s Authenticating...", this.remoteAddress);
        if (this.prefs.isEnablePassword()) {
            if (!CollectionsUtil.compareArrays(this.prefs.getPasswordHash(), passwordHash)) {
                this.server.addActivity("%s Password invalid.", this.remoteAddress);
                this.sendWrongPasswordError();
                return;
            }
        } else {
            this.server.addActivity("%s Password not enabled.", this.remoteAddress);
        }
        this.authenticated = true;
        this.server.addActivity("%s Authenticated.", this.remoteAddress);
        this.sendAuthenticated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePlayerRequest() throws Throwable {
        int player = this.in.readInt();
        if (player < 4) {
            this.server.addActivity("%s Requests to be player %d.", this.remoteAddress, player + 1);
        } else {
            this.server.addActivity("%s Requests to be a spectator.", this.remoteAddress);
        }
        int playerResponse = this.server.requestPlayer(this, player);
        if (playerResponse == 255) {
            this.server.addActivity("%s Request granted.", this.remoteAddress);
        } else {
            this.server.addActivity("%s Request denied.", this.remoteAddress);
        }
        Object object = this.writeMonitor;
        synchronized (object) {
            this.out.write(6);
            this.out.write(playerResponse);
            this.out.flush();
        }
    }

    private void resetPauseTime() {
        this.setPauseTime(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPauseTime(long pauseTime) {
        Object object = this.pauseMonitor;
        synchronized (object) {
            this.pauseTime = pauseTime;
            this.pauseMonitor.notifyAll();
        }
    }

    public void pause(int fileRequestID) {
        this.server.pause(this, fileRequestID);
        this.setPauseTime(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFileRequest() throws Throwable {
        this.server.addActivity("%s Requests file and saved state.", this.remoteAddress);
        IFile file = App.getFile();
        MachineRunner machineRunner = App.getMachineRunner();
        if (file != null && machineRunner != null) {
            Movie movie = machineRunner.getMovie();
            Object object = this.writeMonitor;
            synchronized (object) {
                Ports ports = AppPrefs.getInstance().getInputs().getPorts();
                int fileRequestID = this.server.createFileRequestID();
                this.pause(fileRequestID);
                this.postFileAndSaveState(StreamUtil.toByteArrayOutputStream(new FileResponse(fileRequestID, file, machineRunner.getMachine(), movie != null ? movie.getFrameIndex() : 0, machineRunner.isForwardTime(), machineRunner.getCurrentMovieBlock(), machineRunner.getMovieBlock(), ports.getConsoleType(), ports.isMultitap(), this.server.getQuickSaveStateMenuNames(), App.getImageFrame().getFileInfo())).toByteArray(), true);
            }
        } else {
            this.postFileAndSaveState(null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFileAndSaveState(byte[] fileResponse, boolean paused) {
        Object object = this.writeMonitor;
        synchronized (object) {
            if (paused) {
                this.postEnabled = false;
            }
            if (fileResponse != null) {
                this.sendQueue.produce(8, fileResponse);
                this.server.addActivity("%s Sent file data and saved state.", this.remoteAddress);
            } else {
                this.sendQueue.produce(9);
                this.server.addActivity("%s Sent file closed message.", this.remoteAddress);
            }
        }
    }

    public void post(int messageType, int value, byte[] data) {
        if (this.postEnabled) {
            this.sendQueue.produce(messageType, value, data);
        }
    }

    public void post(int messageType, byte[] data) {
        if (this.postEnabled) {
            this.sendQueue.produce(messageType, data);
        }
    }

    public void post(int messageType, int value) {
        if (this.postEnabled) {
            this.sendQueue.produce(messageType, value);
        }
    }

    public void post(int type) {
        if (this.postEnabled) {
            this.sendQueue.produce(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAuthenticated() throws Throwable {
        Object object = this.writeMonitor;
        synchronized (object) {
            this.out.write(4);
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWrongPasswordError() throws Throwable {
        Object object = this.writeMonitor;
        synchronized (object) {
            this.out.write(3);
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeartbeat() throws Throwable {
        Object object = this.writeMonitor;
        synchronized (object) {
            this.out.write(0);
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendServerDescription() throws Throwable {
        Object object = this.writeMonitor;
        synchronized (object) {
            this.out.write(1);
            this.out.writeUTF(VersionUtil.getVersion());
            StreamUtil.writeRawByteArray(this.out, this.prefs.getPasswordSalt());
            this.out.writeBoolean(this.prefs.isAllowQuickSaves());
            this.out.flush();
        }
    }

    private void closeSocket() {
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void breakConnection() {
        this.closeSocket();
        ThreadUtil.interruptAll(this.mainThread, this.sendThread, this.heartbeatThread, this.pauseThread);
    }

    private void kill() {
        this.running = false;
        this.postEnabled = false;
        this.breakConnection();
        this.sendQueue.stop();
    }

    public void dispose() {
        this.kill();
    }

    public String toString() {
        return this.remoteAddress;
    }
}

