/*
 * Decompiled with CFR 0.152.
 */
package nintaco.palettes;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nintaco.palettes.PalettePPU;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;

public class Palettes
implements Serializable {
    private static final long serialVersionUID = 0L;
    final Map<PalettePPU, String> ppuPaletteMapping = new HashMap<PalettePPU, String>();
    final Map<String, int[]> originalPalettes = new HashMap<String, int[]>();
    final Map<String, int[]> modifiedPalettes = new HashMap<String, int[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPpuPaletteMapping(Map<PalettePPU, String> ppuPaletteMapping) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            this.ppuPaletteMapping.clear();
            this.ppuPaletteMapping.putAll(ppuPaletteMapping);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPpuPaletteMapping(Map<PalettePPU, String> ppuPaletteMapping) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            ppuPaletteMapping.clear();
            ppuPaletteMapping.putAll(this.ppuPaletteMapping);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPalette(String name, int[] palette) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            int[] p = new int[64];
            System.arraycopy(palette, 0, p, 0, 64);
            this.modifiedPalettes.put(name, p);
            if (!this.originalPalettes.containsKey(name)) {
                p = new int[64];
                System.arraycopy(palette, 0, p, 0, 64);
                this.originalPalettes.put(name, p);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getOriginalPalette(String name, int[] palette) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            int[] p = this.originalPalettes.get(name);
            if (p != null) {
                System.arraycopy(p, 0, palette, 0, 64);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPalettes(Map<String, int[]> palettes) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            for (Map.Entry<String, int[]> entry : palettes.entrySet()) {
                this.setPalette(entry.getKey(), entry.getValue());
            }
            Iterator<Map.Entry<String, int[]>> i = this.originalPalettes.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, int[]> entry;
                entry = i.next();
                String name = entry.getKey();
                if (PaletteUtil.isStandardPaletteName(name) || palettes.containsKey(name)) continue;
                i.remove();
                this.modifiedPalettes.remove(name);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPalettes(Map<String, int[]> palettes) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            palettes.clear();
            for (String name : this.originalPalettes.keySet()) {
                int[] palette = new int[64];
                this.getPalette(name, palette);
                palettes.put(name, palette);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean getPalette(PalettePPU palettePPU, int[] palette) {
        return this.getPalette(this.ppuPaletteMapping.get((Object)palettePPU), palette);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPalette(String name, int[] palette) {
        if (name == null || palette == null || palette.length < 64) {
            return false;
        }
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            int[] p = this.modifiedPalettes.get(name);
            if (p == null) {
                p = this.originalPalettes.get(name);
            }
            if (p != null) {
                System.arraycopy(p, 0, palette, 0, 64);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPaletteNames(List<String> names) {
        Class<AppPrefs> clazz = AppPrefs.class;
        synchronized (AppPrefs.class) {
            names.clear();
            names.addAll(this.originalPalettes.keySet());
            Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

