/*
 * Decompiled with CFR 0.152.
 */
package nintaco.task;

public abstract class Task
implements Runnable {
    protected volatile boolean running;
    protected volatile boolean canceled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Task task = this;
        synchronized (task) {
            if (this.canceled) {
                return;
            }
            this.running = true;
        }
        try {
            this.loop();
        }
        finally {
            this.running = false;
        }
    }

    public abstract void loop();

    public synchronized void cancel() {
        this.running = false;
        this.canceled = true;
        this.notifyAll();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isRunning() {
        return this.running;
    }
}

